/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.EAP;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.RADIUSAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RADIUS
extends BasePacket {
    protected byte code;
    protected byte identifier;
    protected short length = (short)20;
    protected byte[] authenticator = new byte[16];
    protected List<RADIUSAttribute> attributes = new ArrayList<RADIUSAttribute>();
    public static final short RADIUS_MIN_LENGTH = 20;
    public static final short MAX_ATTR_VALUE_LENGTH = 253;
    public static final short RADIUS_MAX_LENGTH = 4096;
    public static final byte RADIUS_CODE_ACCESS_REQUEST = 1;
    public static final byte RADIUS_CODE_ACCESS_ACCEPT = 2;
    public static final byte RADIUS_CODE_ACCESS_REJECT = 3;
    public static final byte RADIUS_CODE_ACCOUNTING_REQUEST = 4;
    public static final byte RADIUS_CODE_ACCOUNTING_RESPONSE = 5;
    public static final byte RADIUS_CODE_ACCESS_CHALLENGE = 11;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public RADIUS() {
    }

    public RADIUS(byte code, byte identifier) {
        this.code = code;
        this.identifier = identifier;
    }

    public byte getCode() {
        return this.code;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    public byte getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(byte identifier) {
        this.identifier = identifier;
    }

    public byte[] getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(byte[] authenticator) {
        this.authenticator = authenticator;
    }

    public byte[] generateAuthCode() {
        new SecureRandom().nextBytes(this.authenticator);
        return this.authenticator;
    }

    public boolean isValidCode() {
        return this.code == 1 || this.code == 2 || this.code == 3 || this.code == 4 || this.code == 5 || this.code == 11;
    }

    public RADIUSAttribute addMessageAuthenticator(String key) {
        byte[] hashOutput = new byte[16];
        Arrays.fill(hashOutput, (byte)0);
        RADIUSAttribute authAttribute = this.getAttribute((byte)80);
        if (authAttribute != null) {
            this.log.warn("Attempted to add duplicate Message-Authenticator");
            authAttribute = this.updateAttribute((byte)80, hashOutput);
        } else {
            authAttribute = this.setAttribute((byte)80, hashOutput);
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "HmacMD5");
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(keySpec);
            hashOutput = mac.doFinal(this.serialize());
            authAttribute = this.updateAttribute((byte)80, hashOutput);
        }
        catch (Exception e) {
            this.log.error("Failed to generate message authenticator: {}", (Object)e.getMessage());
        }
        return authAttribute;
    }

    public boolean checkMessageAuthenticator(String key) {
        byte[] newHash = new byte[16];
        Arrays.fill(newHash, (byte)0);
        byte[] messageAuthenticator = this.getAttribute((byte)80).getValue();
        this.updateAttribute((byte)80, newHash);
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "HmacMD5");
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(keySpec);
            newHash = mac.doFinal(this.serialize());
        }
        catch (Exception e) {
            this.log.error("Failed to generate message authenticator: {}", (Object)e.getMessage());
        }
        this.updateAttribute((byte)80, messageAuthenticator);
        return Arrays.equals(newHash, messageAuthenticator);
    }

    public void encapsulateMessage(EAP message) {
        if (message.length <= 253) {
            this.setAttribute((byte)79, message.serialize());
        } else {
            short remainingLength = message.length;
            byte[] messageBuffer = message.serialize();
            ByteBuffer bb = ByteBuffer.wrap(messageBuffer);
            while (bb.hasRemaining()) {
                byte[] messageAttributeData;
                if (remainingLength > 253) {
                    messageAttributeData = new byte[253];
                    bb.get(messageAttributeData, 0, 253);
                    remainingLength = (short)(remainingLength - 253);
                } else {
                    messageAttributeData = new byte[remainingLength];
                    bb.get(messageAttributeData, 0, remainingLength);
                }
                this.attributes.add(new RADIUSAttribute(79, (byte)(messageAttributeData.length + 2), messageAttributeData));
                this.length = (short)(this.length + (short)(messageAttributeData.length & 0xFF));
                this.length = (short)(this.length + 2);
            }
        }
    }

    public EAP decapsulateMessage() throws DeserializationException {
        EAP message = new EAP();
        ByteArrayOutputStream messageStream = new ByteArrayOutputStream();
        for (RADIUSAttribute ra : this.getAttributeList((byte)79)) {
            try {
                messageStream.write(ra.getValue());
            }
            catch (IOException e) {
                this.log.error("Error while reassembling EAP message: {}", (Object)e.getMessage());
            }
        }
        message = EAP.deserializer().deserialize(messageStream.toByteArray(), 0, messageStream.size());
        return message;
    }

    public ArrayList<RADIUSAttribute> getAttributeList(byte attrType) {
        ArrayList<RADIUSAttribute> attrList = new ArrayList<RADIUSAttribute>();
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (this.attributes.get(i).getType() != attrType) continue;
            attrList.add(this.attributes.get(i));
        }
        return attrList;
    }

    public RADIUSAttribute getAttribute(byte attrType) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (this.attributes.get(i).getType() != attrType) continue;
            return this.attributes.get(i);
        }
        return null;
    }

    public RADIUSAttribute setAttribute(byte attrType, byte[] value) {
        byte attrLength = (byte)(value.length + 2);
        RADIUSAttribute newAttribute = new RADIUSAttribute(attrType, attrLength, value);
        this.attributes.add(newAttribute);
        this.length = (short)(this.length + (short)(attrLength & 0xFF));
        return newAttribute;
    }

    public RADIUSAttribute updateAttribute(byte attrType, byte[] value) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (this.attributes.get(i).getType() != attrType) continue;
            this.length = (short)(this.length - (short)(this.attributes.get(i).getLength() & 0xFF));
            RADIUSAttribute newAttr = new RADIUSAttribute(attrType, (byte)(value.length + 2), value);
            this.attributes.set(i, newAttr);
            this.length = (short)(this.length + (short)(newAttr.getLength() & 0xFF));
            return newAttr;
        }
        return null;
    }

    public static Deserializer<RADIUS> deserializer() {
        return (data, offset, length) -> {
            short attrLength;
            PacketUtils.checkInput(data, offset, length, 20);
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            RADIUS radius = new RADIUS();
            radius.code = bb.get();
            radius.identifier = bb.get();
            radius.length = bb.getShort();
            bb.get(radius.authenticator, 0, 16);
            PacketUtils.checkHeaderLength(length, radius.length);
            for (int remainingLength = radius.length - 20; remainingLength > 0 && bb.hasRemaining(); remainingLength -= attrLength) {
                RADIUSAttribute attr = new RADIUSAttribute();
                attr.setType(bb.get());
                attr.setLength(bb.get());
                attrLength = (short)(attr.length & 0xFF);
                attr.value = new byte[attrLength - 2];
                bb.get(attr.value, 0, attrLength - 2);
                radius.attributes.add(attr);
            }
            return radius;
        };
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[this.length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.code);
        bb.put(this.identifier);
        bb.putShort(this.length);
        bb.put(this.authenticator);
        for (int i = 0; i < this.attributes.size(); ++i) {
            RADIUSAttribute attr = this.attributes.get(i);
            bb.put(attr.getType());
            bb.put(attr.getLength());
            bb.put(attr.getValue());
        }
        return data;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("code", (Object)Byte.toString(this.code)).add("identifier", (Object)Byte.toString(this.identifier)).add("length", (Object)Short.toString(this.length)).add("authenticator", (Object)Arrays.toString(this.authenticator)).toString();
    }
}

