/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Vertex;

public class AdjacencyListsGraphTest {
    private static final TestVertex A = new TestVertex("A");
    private static final TestVertex B = new TestVertex("B");
    private static final TestVertex C = new TestVertex("C");
    private static final TestVertex D = new TestVertex("D");
    private static final TestVertex E = new TestVertex("E");
    private static final TestVertex F = new TestVertex("F");
    private static final TestVertex G = new TestVertex("G");
    private final Set<TestEdge> edges = ImmutableSet.of((Object)((Object)new TestEdge(A, B)), (Object)((Object)new TestEdge(B, C)), (Object)((Object)new TestEdge(C, D)), (Object)((Object)new TestEdge(D, A)), (Object)((Object)new TestEdge(B, D)));

    @Test
    public void equality() {
        ImmutableSet vertexes = ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F, (Object[])new TestVertex[0]);
        ImmutableSet vertexes2 = ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F, (Object[])new TestVertex[]{G});
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)vertexes, this.edges);
        AdjacencyListsGraph same = new AdjacencyListsGraph((Set)vertexes, this.edges);
        AdjacencyListsGraph different = new AdjacencyListsGraph((Set)vertexes2, this.edges);
        new EqualsTester().addEqualityGroup(new Object[]{graph, same}).addEqualityGroup(new Object[]{different}).testEquals();
    }

    @Test
    public void basics() {
        ImmutableSet vertexes = ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F, (Object[])new TestVertex[0]);
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)vertexes, this.edges);
        Assert.assertEquals((String)"incorrect vertex count", (long)6L, (long)graph.getVertexes().size());
        Assert.assertEquals((String)"incorrect edge count", (long)5L, (long)graph.getEdges().size());
        Assert.assertEquals((String)"incorrect egress edge count", (long)1L, (long)graph.getEdgesFrom((Vertex)A).size());
        Assert.assertEquals((String)"incorrect ingress edge count", (long)1L, (long)graph.getEdgesTo((Vertex)A).size());
        Assert.assertEquals((String)"incorrect ingress edge count", (long)1L, (long)graph.getEdgesTo((Vertex)C).size());
        Assert.assertEquals((String)"incorrect egress edge count", (long)2L, (long)graph.getEdgesFrom((Vertex)B).size());
        Assert.assertEquals((String)"incorrect ingress edge count", (long)2L, (long)graph.getEdgesTo((Vertex)D).size());
    }
}

