/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.testing.EqualsTester;
import java.util.ArrayList;
import java.util.Comparator;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.Heap;

public class HeapTest {
    private ArrayList<Integer> data = new ArrayList(ImmutableList.of((Object)6, (Object)4, (Object)5, (Object)9, (Object)8, (Object)3, (Object)2, (Object)1, (Object)7, (Object)0));
    private static final Comparator<Integer> MIN = Ordering.natural().reverse();
    private static final Comparator<Integer> MAX = Ordering.natural();

    @Test
    public void equality() {
        new EqualsTester().addEqualityGroup(new Object[]{new Heap(this.data, MIN), new Heap(this.data, MIN)}).addEqualityGroup(new Object[]{new Heap(this.data, MAX)}).testEquals();
    }

    @Test
    public void empty() {
        Heap h = new Heap(new ArrayList(), MIN);
        Assert.assertTrue((String)"should be empty", (boolean)h.isEmpty());
        Assert.assertEquals((String)"incorrect size", (long)0L, (long)h.size());
        Assert.assertNull((String)"no item expected", (Object)h.extreme());
        Assert.assertNull((String)"no item expected", (Object)h.extractExtreme());
    }

    @Test
    public void insert() {
        Heap h = new Heap(this.data, MIN);
        Assert.assertEquals((String)"incorrect size", (long)10L, (long)h.size());
        h.insert((Object)3);
        Assert.assertEquals((String)"incorrect size", (long)11L, (long)h.size());
    }

    @Test
    public void minQueue() {
        Heap h = new Heap(this.data, MIN);
        Assert.assertFalse((String)"should not be empty", (boolean)h.isEmpty());
        Assert.assertEquals((String)"incorrect size", (long)10L, (long)h.size());
        Assert.assertEquals((String)"incorrect extreme", (Object)0, (Object)h.extreme());
        int n = h.size();
        for (int i = 0; i < n; ++i) {
            Assert.assertEquals((String)"incorrect element", (Object)i, (Object)h.extractExtreme());
        }
        Assert.assertTrue((String)"should be empty", (boolean)h.isEmpty());
    }

    @Test
    public void maxQueue() {
        Heap h = new Heap(this.data, MAX);
        Assert.assertFalse((String)"should not be empty", (boolean)h.isEmpty());
        Assert.assertEquals((String)"incorrect size", (long)10L, (long)h.size());
        Assert.assertEquals((String)"incorrect extreme", (Object)9, (Object)h.extreme());
        for (int i = h.size(); i > 0; --i) {
            Assert.assertEquals((String)"incorrect element", (Object)(i - 1), (Object)h.extractExtreme());
        }
        Assert.assertTrue((String)"should be empty", (boolean)h.isEmpty());
    }

    @Test
    public void iterator() {
        Heap h = new Heap(this.data, MIN);
        Assert.assertTrue((String)"should have next element", (boolean)h.iterator().hasNext());
    }
}

