/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Map;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.PacketUtils;

public class MPLS
extends BasePacket {
    public static final int HEADER_LENGTH = 4;
    public static final byte PROTOCOL_IPV4 = 1;
    public static final byte PROTOCOL_MPLS = 6;
    static Map<Byte, Deserializer<? extends IPacket>> protocolDeserializerMap = ImmutableMap.builder().put((Object)1, IPv4.deserializer()).put((Object)6, MPLS.deserializer()).build();
    protected int label;
    protected byte bos = 1;
    protected byte ttl;
    protected byte protocol = 1;

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        byte[] data = new byte[4 + (payloadData != null ? payloadData.length : 0)];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putInt((this.label & 0xFFFFF) << 12 | ((this.bos & 1) << 8 | this.ttl & 0xFF));
        if (payloadData != null) {
            bb.put(payloadData);
        }
        return data;
    }

    public int getLabel() {
        return this.label;
    }

    public void setLabel(int label) {
        this.label = label;
    }

    public byte getTtl() {
        return this.ttl;
    }

    public void setTtl(byte ttl) {
        this.ttl = ttl;
    }

    public static Deserializer<MPLS> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 4);
            MPLS mpls = new MPLS();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            int mplsheader = bb.getInt();
            mpls.label = (mplsheader & 0xFFFFF000) >>> 12;
            mpls.bos = (byte)((mplsheader & 0x100) >> 8);
            mpls.ttl = (byte)(mplsheader & 0xFF);
            mpls.protocol = (byte)(mpls.bos == 1 ? 1 : 6);
            Deserializer<IPacket> deserializer = protocolDeserializerMap.containsKey(mpls.protocol) ? protocolDeserializerMap.get(mpls.protocol) : Data.deserializer();
            mpls.payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            mpls.payload.setParent(mpls);
            return mpls;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("label", (Object)Integer.toString(this.label)).add("bos", (Object)Byte.toString(this.bos)).add("ttl", (Object)Byte.toString(this.ttl)).add("protocol", (Object)Byte.toString(this.protocol)).toString();
    }
}

