/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIPV2AuthEntry
extends BasePacket {
    private static final int ENTRY_LEN = 20;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected short addressFamilyId;
    protected short type;
    protected short offset;
    protected byte keyId;
    protected byte authLen;
    protected int sequence;

    @Override
    public byte[] serialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        byteBuffer.putShort(this.addressFamilyId);
        byteBuffer.putShort(this.type);
        byteBuffer.putShort(this.offset);
        byteBuffer.put(this.keyId);
        byteBuffer.put(this.authLen);
        byteBuffer.putInt(this.sequence);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        return byteBuffer.array();
    }

    public static Deserializer<RIPV2AuthEntry> deserializer() {
        return (data, offset, length) -> {
            RIPV2AuthEntry authEntry = new RIPV2AuthEntry();
            Preconditions.checkNotNull((Object)data);
            if (offset < 0 || length < 0 || length > data.length || offset >= data.length || offset + length > data.length) {
                throw new DeserializationException("Illegal offset or length");
            }
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            if (bb.remaining() < 20) {
                throw new DeserializationException("Buffer underflow while reading RIP authentication entry");
            }
            authEntry.addressFamilyId = bb.getShort();
            authEntry.type = bb.getShort();
            authEntry.offset = bb.getShort();
            authEntry.keyId = bb.get();
            authEntry.authLen = bb.get();
            authEntry.sequence = bb.getInt();
            return authEntry;
        };
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sequence, this.authLen, this.keyId, this.offset, this.addressFamilyId, this.type);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RIPV2AuthEntry)) {
            return false;
        }
        RIPV2AuthEntry that = (RIPV2AuthEntry)obj;
        return super.equals(that) && Objects.equals(this.type, that.type) && Objects.equals(this.addressFamilyId, that.addressFamilyId) && Objects.equals(this.offset, that.offset) && Objects.equals(this.keyId, that.keyId) && Objects.equals(this.authLen, that.authLen) && Objects.equals(this.sequence, that.sequence);
    }

    public short getAddressFamilyId() {
        return this.addressFamilyId;
    }

    public RIPV2AuthEntry setAddressFamilyId(short addressFamilyIdentifier) {
        this.addressFamilyId = addressFamilyIdentifier;
        return this;
    }

    public short getType() {
        return this.type;
    }

    public RIPV2AuthEntry setType(short type) {
        this.type = type;
        return this;
    }

    public short getOffset() {
        return this.offset;
    }

    public RIPV2AuthEntry setOffset(short offset) {
        this.offset = offset;
        return this;
    }

    public byte getKeyId() {
        return this.keyId;
    }

    public RIPV2AuthEntry setKeyId(byte keyId) {
        this.keyId = keyId;
        return this;
    }

    public byte getAuthLen() {
        return this.authLen;
    }

    public RIPV2AuthEntry setAuthLen(byte authlen) {
        this.authLen = authlen;
        return this;
    }

    public int getSequence() {
        return this.sequence;
    }

    public RIPV2AuthEntry setSequenceNumber(int sequencenumber) {
        this.sequence = sequencenumber;
        return this;
    }

    public String toString() {
        return "RIPV2AuthEntry [address family Id=" + this.addressFamilyId + ", type=" + this.type + ", offset=" + this.offset + ", key ID=" + this.keyId + ", authentication length = " + this.authLen + ", sequence number=" + this.sequence + "]";
    }
}

