/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;

public abstract class BasePacket
implements IPacket {
    protected IPacket parent;
    protected IPacket payload;

    @Override
    public IPacket getParent() {
        return this.parent;
    }

    @Override
    public IPacket setParent(IPacket parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public IPacket getPayload() {
        return this.payload;
    }

    @Override
    public IPacket setPayload(IPacket payload) {
        this.payload = payload;
        return this;
    }

    @Override
    public void resetChecksum() {
        if (this.parent != null) {
            this.parent.resetChecksum();
        }
    }

    public int hashCode() {
        int prime = 6733;
        int result = 1;
        result = 6733 * result + (this.payload == null ? 0 : this.payload.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BasePacket)) {
            return false;
        }
        BasePacket other = (BasePacket)obj;
        return !(this.payload == null ? other.payload != null : !this.payload.equals(other.payload));
    }

    public Object clone() {
        Class<?> packetClass = this.getClass();
        Method[] allMethods = packetClass.getDeclaredMethods();
        Method deserializerFactory = null;
        for (Method m : allMethods) {
            String mname = m.getName();
            if (!mname.equals("deserializer")) continue;
            deserializerFactory = m;
            break;
        }
        if (deserializerFactory == null) {
            throw new IllegalStateException("No Deserializer found for " + packetClass.getName());
        }
        byte[] data = this.serialize();
        try {
            Deserializer deserializer = (Deserializer)deserializerFactory.invoke((Object)this, new Object[0]);
            return deserializer.deserialize(data, 0, data.length);
        }
        catch (IllegalAccessException | InvocationTargetException | DeserializationException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

