/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.onlab.packet.DHCP6;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.dhcp.Dhcp6Option;

public final class Dhcp6IaAddressOption
extends Dhcp6Option {
    public static final int DEFAULT_LEN = 24;
    private Ip6Address ip6Address;
    private int preferredLifetime;
    private int validLifetime;
    private IPacket options;

    @Override
    public short getCode() {
        return DHCP6.OptionCode.IAADDR.value();
    }

    @Override
    public short getLength() {
        return (short)(this.options == null ? 24 : 24 + this.options.serialize().length);
    }

    public void setIp6Address(Ip6Address ip6Address) {
        this.ip6Address = ip6Address;
    }

    public void setPreferredLifetime(int preferredLifetime) {
        this.preferredLifetime = preferredLifetime;
    }

    public void setValidLifetime(int validLifetime) {
        this.validLifetime = validLifetime;
    }

    public void setOptions(IPacket options) {
        this.options = options;
    }

    public Ip6Address getIp6Address() {
        return this.ip6Address;
    }

    public int getPreferredLifetime() {
        return this.preferredLifetime;
    }

    public int getValidLifetime() {
        return this.validLifetime;
    }

    public IPacket getOptions() {
        return this.options;
    }

    public static Deserializer<Dhcp6Option> deserializer() {
        return (data, offset, length) -> {
            Dhcp6IaAddressOption iaAddressOption = new Dhcp6IaAddressOption();
            Dhcp6Option dhcp6Option = Dhcp6Option.deserializer().deserialize(data, offset, length);
            iaAddressOption.setPayload(dhcp6Option.getPayload());
            if (dhcp6Option.getLength() < 24) {
                throw new DeserializationException("Invalid length of IA address option");
            }
            ByteBuffer bb = ByteBuffer.wrap(dhcp6Option.getData());
            byte[] ipv6Addr = new byte[16];
            bb.get(ipv6Addr);
            iaAddressOption.ip6Address = Ip6Address.valueOf(ipv6Addr);
            iaAddressOption.preferredLifetime = bb.getInt();
            iaAddressOption.validLifetime = bb.getInt();
            int optionsLen = dhcp6Option.getLength() - 24;
            if (optionsLen > 0) {
                byte[] optionsData = new byte[optionsLen];
                bb.get(optionsData);
                iaAddressOption.options = Data.deserializer().deserialize(optionsData, 0, optionsLen);
            }
            return iaAddressOption;
        };
    }

    @Override
    public byte[] serialize() {
        int payloadLen = this.options == null ? 24 : 24 + this.options.serialize().length;
        ByteBuffer bb = ByteBuffer.allocate(payloadLen + 4);
        bb.putShort(DHCP6.OptionCode.IAADDR.value());
        bb.putShort((short)payloadLen);
        bb.put(this.ip6Address.toOctets());
        bb.putInt(this.preferredLifetime);
        bb.putInt(this.validLifetime);
        if (this.options != null) {
            bb.put(this.options.serialize());
        }
        return bb.array();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.ip6Address, this.preferredLifetime, this.validLifetime, this.options);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dhcp6IaAddressOption)) {
            return false;
        }
        Dhcp6IaAddressOption other = (Dhcp6IaAddressOption)obj;
        return Objects.equals(this.getCode(), other.getCode()) && Objects.equals(this.getLength(), other.getLength()) && Objects.equals(this.ip6Address, other.ip6Address) && Objects.equals(this.preferredLifetime, other.preferredLifetime) && Objects.equals(this.validLifetime, other.validLifetime) && Objects.equals(this.options, other.options);
    }

    @Override
    public String toString() {
        return this.getToStringHelper().add("ip6Address", (Object)this.ip6Address).add("preferredLifetime", this.preferredLifetime).add("validLifetime", this.validLifetime).add("options", (Object)this.options).toString();
    }
}

