/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.onlab.packet.ARP;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DHCP;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.EAPOL;
import org.onlab.packet.EthType;
import org.onlab.packet.ICMP;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.LLC;
import org.onlab.packet.LLDP;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.TCP;
import org.onlab.packet.UDP;
import org.onlab.packet.ndp.NeighborAdvertisement;
import org.onlab.packet.ndp.NeighborSolicitation;
import org.onlab.packet.ndp.Redirect;
import org.onlab.packet.ndp.RouterAdvertisement;
import org.onlab.packet.ndp.RouterSolicitation;

public class Ethernet
extends BasePacket {
    private static final String HEXES = "0123456789ABCDEF";
    private static final String HEX_PROTO = "0x%s";
    public static final short TYPE_ARP = EthType.EtherType.ARP.ethType().toShort();
    public static final short TYPE_RARP = EthType.EtherType.RARP.ethType().toShort();
    public static final short TYPE_IPV4 = EthType.EtherType.IPV4.ethType().toShort();
    public static final short TYPE_IPV6 = EthType.EtherType.IPV6.ethType().toShort();
    public static final short TYPE_LLDP = EthType.EtherType.LLDP.ethType().toShort();
    public static final short TYPE_VLAN = EthType.EtherType.VLAN.ethType().toShort();
    public static final short TYPE_QINQ = EthType.EtherType.QINQ.ethType().toShort();
    public static final short TYPE_BSN = EthType.EtherType.BDDP.ethType().toShort();
    public static final short MPLS_UNICAST = EthType.EtherType.MPLS_UNICAST.ethType().toShort();
    public static final short MPLS_MULTICAST = EthType.EtherType.MPLS_MULTICAST.ethType().toShort();
    public static final short VLAN_UNTAGGED = -1;
    public static final short ETHERNET_HEADER_LENGTH = 14;
    public static final short VLAN_HEADER_LENGTH = 4;
    public static final short DATALAYER_ADDRESS_LENGTH = 6;
    private static final Map<Short, Deserializer<? extends IPacket>> ETHERTYPE_DESERIALIZER_MAP;
    protected MacAddress destinationMACAddress;
    protected MacAddress sourceMACAddress;
    protected byte priorityCode;
    protected byte qInQPriorityCode;
    protected short vlanID = (short)-1;
    protected short qinqVID = (short)-1;
    protected short qinqTPID = TYPE_QINQ;
    protected short etherType;
    protected boolean pad = false;

    public byte[] getDestinationMACAddress() {
        return this.destinationMACAddress.toBytes();
    }

    public MacAddress getDestinationMAC() {
        return this.destinationMACAddress;
    }

    public Ethernet setDestinationMACAddress(MacAddress destMac) {
        this.destinationMACAddress = (MacAddress)Preconditions.checkNotNull((Object)destMac);
        return this;
    }

    public Ethernet setDestinationMACAddress(byte[] destMac) {
        this.destinationMACAddress = MacAddress.valueOf(destMac);
        return this;
    }

    public Ethernet setDestinationMACAddress(String destMac) {
        this.destinationMACAddress = MacAddress.valueOf(destMac);
        return this;
    }

    public byte[] getSourceMACAddress() {
        return this.sourceMACAddress.toBytes();
    }

    public MacAddress getSourceMAC() {
        return this.sourceMACAddress;
    }

    public Ethernet setSourceMACAddress(MacAddress sourceMac) {
        this.sourceMACAddress = (MacAddress)Preconditions.checkNotNull((Object)sourceMac);
        return this;
    }

    public Ethernet setSourceMACAddress(byte[] sourceMac) {
        this.sourceMACAddress = MacAddress.valueOf(sourceMac);
        return this;
    }

    public Ethernet setSourceMACAddress(String sourceMac) {
        this.sourceMACAddress = MacAddress.valueOf(sourceMac);
        return this;
    }

    public byte getPriorityCode() {
        return this.priorityCode;
    }

    public Ethernet setPriorityCode(byte priority) {
        this.priorityCode = priority;
        return this;
    }

    public byte getQinQPriorityCode() {
        return this.qInQPriorityCode;
    }

    public Ethernet setQinQPriorityCode(byte priority) {
        this.qInQPriorityCode = priority;
        return this;
    }

    public short getVlanID() {
        return this.vlanID;
    }

    public Ethernet setVlanID(short vlan) {
        this.vlanID = vlan;
        return this;
    }

    public short getQinQVID() {
        return this.qinqVID;
    }

    public Ethernet setQinQVID(short vlan) {
        this.qinqVID = vlan;
        return this;
    }

    public short getQinQTPID() {
        return this.qinqTPID;
    }

    public Ethernet setQinQTPID(short tpId) {
        if (tpId != TYPE_VLAN && tpId != TYPE_QINQ) {
            return null;
        }
        this.qinqTPID = tpId;
        return this;
    }

    public short getEtherType() {
        return this.etherType;
    }

    public Ethernet setEtherType(short ethType) {
        this.etherType = ethType;
        return this;
    }

    public boolean isBroadcast() {
        assert (this.destinationMACAddress.length() == 6);
        return this.destinationMACAddress.isBroadcast();
    }

    public boolean isMulticast() {
        return this.destinationMACAddress.isMulticast();
    }

    public boolean isPad() {
        return this.pad;
    }

    public Ethernet setPad(boolean pd) {
        this.pad = pd;
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        int length = 14 + (this.vlanID == -1 ? 0 : 4) + (this.qinqVID == -1 ? 0 : 4) + (payloadData == null ? 0 : payloadData.length);
        if (this.pad && length < 60) {
            length = 60;
        }
        byte[] data = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.destinationMACAddress.toBytes());
        bb.put(this.sourceMACAddress.toBytes());
        if (this.qinqVID != -1) {
            bb.putShort(this.qinqTPID);
            bb.putShort((short)(this.qInQPriorityCode << 13 | this.qinqVID & 0xFFF));
        }
        if (this.vlanID != -1) {
            bb.putShort(TYPE_VLAN);
            bb.putShort((short)(this.priorityCode << 13 | this.vlanID & 0xFFF));
        }
        bb.putShort(this.etherType);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        if (this.pad) {
            Arrays.fill(data, bb.position(), data.length, (byte)0);
        }
        return data;
    }

    public static boolean isMACAddress(String macAddress) {
        String[] macBytes = macAddress.split(":");
        if (macBytes.length != 6) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (HEXES.indexOf(macBytes[i].toUpperCase().charAt(0)) != -1 && HEXES.indexOf(macBytes[i].toUpperCase().charAt(1)) != -1) continue;
            return false;
        }
        return true;
    }

    public static byte[] toMACAddress(String macAddress) {
        return MacAddress.valueOf(macAddress).toBytes();
    }

    public static long toLong(byte[] macAddress) {
        return MacAddress.valueOf(macAddress).toLong();
    }

    public static byte[] toByteArray(long macAddress) {
        return MacAddress.valueOf(macAddress).toBytes();
    }

    @Override
    public int hashCode() {
        int prime = 7867;
        int result = super.hashCode();
        result = 7867 * result + this.destinationMACAddress.hashCode();
        result = 7867 * result + this.etherType;
        result = 7867 * result + this.qinqVID;
        result = 7867 * result + this.qInQPriorityCode;
        result = 7867 * result + this.vlanID;
        result = 7867 * result + this.priorityCode;
        result = 7867 * result + (this.pad ? 1231 : 1237);
        result = 7867 * result + this.sourceMACAddress.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Ethernet)) {
            return false;
        }
        Ethernet other = (Ethernet)obj;
        if (!this.destinationMACAddress.equals(other.destinationMACAddress)) {
            return false;
        }
        if (this.qInQPriorityCode != other.qInQPriorityCode) {
            return false;
        }
        if (this.qinqVID != other.qinqVID) {
            return false;
        }
        if (this.priorityCode != other.priorityCode) {
            return false;
        }
        if (this.vlanID != other.vlanID) {
            return false;
        }
        if (this.etherType != other.etherType) {
            return false;
        }
        if (this.pad != other.pad) {
            return false;
        }
        return this.sourceMACAddress.equals(other.sourceMACAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n");
        IPacket pkt = this.getPayload();
        if (pkt instanceof ARP) {
            sb.append("arp");
        } else if (pkt instanceof LLDP) {
            sb.append("lldp");
        } else if (pkt instanceof ICMP) {
            sb.append("icmp");
        } else if (pkt instanceof IPv4) {
            sb.append("ip");
        } else if (pkt instanceof DHCP) {
            sb.append("dhcp");
        } else {
            sb.append(String.format(HEX_PROTO, Integer.toHexString(this.getEtherType() & 0xFFFF)));
        }
        if (this.getQinQVID() != -1) {
            sb.append("\ndl_qinqVlan: ");
            sb.append(this.getQinQVID());
            sb.append("\ndl_qinqVlan_pcp: ");
            sb.append(this.getQinQPriorityCode());
        }
        sb.append("\ndl_vlan: ");
        if (this.getVlanID() == -1) {
            sb.append("untagged");
        } else {
            sb.append(this.getVlanID());
        }
        sb.append("\ndl_vlan_pcp: ");
        sb.append(this.getPriorityCode());
        sb.append("\ndl_src: ");
        sb.append(Ethernet.bytesToHex(this.getSourceMACAddress()));
        sb.append("\ndl_dst: ");
        sb.append(Ethernet.bytesToHex(this.getDestinationMACAddress()));
        if (pkt instanceof ARP) {
            ARP p = (ARP)pkt;
            sb.append("\nnw_src: ");
            sb.append(IPv4.fromIPv4Address(IPv4.toIPv4Address(p.getSenderProtocolAddress())));
            sb.append("\nnw_dst: ");
            sb.append(IPv4.fromIPv4Address(IPv4.toIPv4Address(p.getTargetProtocolAddress())));
        } else if (pkt instanceof LLDP) {
            sb.append("lldp packet");
        } else if (pkt instanceof ICMP) {
            ICMP icmp = (ICMP)pkt;
            sb.append("\nicmp_type: ");
            sb.append(icmp.getIcmpType());
            sb.append("\nicmp_code: ");
            sb.append(icmp.getIcmpCode());
        } else if (pkt instanceof IPv4) {
            IPv4 p = (IPv4)pkt;
            sb.append("\nnw_src: ");
            sb.append(IPv4.fromIPv4Address(p.getSourceAddress()));
            sb.append("\nnw_dst: ");
            sb.append(IPv4.fromIPv4Address(p.getDestinationAddress()));
            sb.append("\nnw_tos: ");
            sb.append(p.getDiffServ());
            sb.append("\nnw_proto: ");
            sb.append(p.getProtocol());
            IPacket payload = pkt.getPayload();
            if (payload != null) {
                if (payload instanceof TCP) {
                    sb.append("\ntp_src: ");
                    sb.append(((TCP)payload).getSourcePort());
                    sb.append("\ntp_dst: ");
                    sb.append(((TCP)payload).getDestinationPort());
                } else if (payload instanceof UDP) {
                    sb.append("\ntp_src: ");
                    sb.append(((UDP)payload).getSourcePort());
                    sb.append("\ntp_dst: ");
                    sb.append(((UDP)payload).getDestinationPort());
                } else if (payload instanceof ICMP) {
                    ICMP icmp = (ICMP)payload;
                    sb.append("\nicmp_type: ");
                    sb.append(icmp.getIcmpType());
                    sb.append("\nicmp_code: ");
                    sb.append(icmp.getIcmpCode());
                }
            }
        } else if (pkt instanceof IPv6) {
            IPv6 ipv6 = (IPv6)pkt;
            sb.append("\nipv6_src: ");
            sb.append(Ip6Address.valueOf(ipv6.getSourceAddress()).toString());
            sb.append("\nipv6_dst: ");
            sb.append(Ip6Address.valueOf(ipv6.getDestinationAddress()).toString());
            sb.append("\nipv6_proto: ");
            sb.append(ipv6.getNextHeader());
            IPacket payload = pkt.getPayload();
            if (payload != null && payload instanceof ICMP6) {
                ICMP6 icmp6 = (ICMP6)payload;
                sb.append("\nicmp6_type: ");
                sb.append(icmp6.getIcmpType());
                sb.append("\nicmp6_code: ");
                sb.append(icmp6.getIcmpCode());
                payload = payload.getPayload();
                if (payload != null) {
                    if (payload instanceof NeighborSolicitation) {
                        NeighborSolicitation ns = (NeighborSolicitation)payload;
                        sb.append("\nns_target_addr: ");
                        sb.append(Ip6Address.valueOf(ns.getTargetAddress()).toString());
                        ns.getOptions().forEach(option -> {
                            sb.append("\noption_type: ");
                            sb.append(option.type());
                            sb.append("\noption_data: ");
                            sb.append(Ethernet.bytesToHex(option.data()));
                        });
                    } else if (payload instanceof NeighborAdvertisement) {
                        NeighborAdvertisement na = (NeighborAdvertisement)payload;
                        sb.append("\nna_target_addr: ");
                        sb.append(Ip6Address.valueOf(na.getTargetAddress()).toString());
                        sb.append("\nna_solicited_flag: ");
                        sb.append(na.getSolicitedFlag());
                        sb.append("\nna_router_flag: ");
                        sb.append(na.getRouterFlag());
                        sb.append("\nna_override_flag: ");
                        sb.append(na.getOverrideFlag());
                        na.getOptions().forEach(option -> {
                            sb.append("\noption_type: ");
                            sb.append(option.type());
                            sb.append("\noption_data: ");
                            sb.append(Ethernet.bytesToHex(option.data()));
                        });
                    } else if (payload instanceof RouterSolicitation) {
                        RouterSolicitation rs = (RouterSolicitation)payload;
                        sb.append("\nrs");
                        rs.getOptions().forEach(option -> {
                            sb.append("\noption_type: ");
                            sb.append(option.type());
                            sb.append("\noption_data: ");
                            sb.append(Ethernet.bytesToHex(option.data()));
                        });
                    } else if (payload instanceof RouterAdvertisement) {
                        RouterAdvertisement ra = (RouterAdvertisement)payload;
                        sb.append("\nra_hop_limit: ");
                        sb.append(ra.getCurrentHopLimit());
                        sb.append("\nra_mflag: ");
                        sb.append(ra.getMFlag());
                        sb.append("\nra_oflag: ");
                        sb.append(ra.getOFlag());
                        sb.append("\nra_reachable_time: ");
                        sb.append(ra.getReachableTime());
                        sb.append("\nra_retransmit_time: ");
                        sb.append(ra.getRetransmitTimer());
                        sb.append("\nra_router_lifetime: ");
                        sb.append(ra.getRouterLifetime());
                        ra.getOptions().forEach(option -> {
                            sb.append("\noption_type: ");
                            sb.append(option.type());
                            sb.append("\noption_data: ");
                            sb.append(Ethernet.bytesToHex(option.data()));
                        });
                    } else if (payload instanceof Redirect) {
                        Redirect rd = (Redirect)payload;
                        sb.append("\nrd_target_addr: ");
                        sb.append(Ip6Address.valueOf(rd.getTargetAddress()).toString());
                        rd.getOptions().forEach(option -> {
                            sb.append("\noption_type: ");
                            sb.append(option.type());
                            sb.append("\noption_data: ");
                            sb.append(Ethernet.bytesToHex(option.data()));
                        });
                    }
                }
            }
        } else if (pkt instanceof DHCP) {
            sb.append("\ndhcp packet");
        } else if (pkt instanceof Data) {
            sb.append("\ndata packet");
        } else if (pkt instanceof LLC) {
            sb.append("\nllc packet");
        } else if (pkt instanceof EAPOL) {
            sb.append("\neapol");
        } else {
            sb.append("\nunknown packet");
        }
        return sb.toString();
    }

    public static String bytesToHex(byte[] in) {
        StringBuilder builder = new StringBuilder();
        for (byte b : in) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    public static Deserializer<Ethernet> deserializer() {
        return (data, offset, length) -> {
            short tci;
            PacketUtils.checkInput(data, offset, length, 14);
            byte[] addressBuffer = new byte[6];
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            Ethernet eth = new Ethernet();
            bb.get(addressBuffer);
            eth.setDestinationMACAddress(addressBuffer);
            bb.get(addressBuffer);
            eth.setSourceMACAddress(addressBuffer);
            short ethType = bb.getShort();
            if (ethType == TYPE_QINQ) {
                PacketUtils.checkHeaderLength(length, 22);
                tci = bb.getShort();
                eth.setQinQPriorityCode((byte)(tci >> 13 & 7));
                eth.setQinQVID((short)(tci & 0xFFF));
                eth.setQinQTPID(TYPE_QINQ);
                ethType = bb.getShort();
            }
            if (ethType == TYPE_VLAN) {
                PacketUtils.checkHeaderLength(length, 18);
                tci = bb.getShort();
                eth.setPriorityCode((byte)(tci >> 13 & 7));
                eth.setVlanID((short)(tci & 0xFFF));
                ethType = bb.getShort();
                if (ethType == TYPE_VLAN) {
                    PacketUtils.checkHeaderLength(length, 18);
                    eth.setQinQPriorityCode(eth.getPriorityCode());
                    eth.setQinQVID(eth.getVlanID());
                    eth.setQinQTPID(TYPE_VLAN);
                    short innerTci = bb.getShort();
                    eth.setPriorityCode((byte)(innerTci >> 13 & 7));
                    eth.setVlanID((short)(innerTci & 0xFFF));
                    ethType = bb.getShort();
                }
            } else {
                eth.setVlanID((short)-1);
            }
            eth.setEtherType(ethType);
            Deserializer<IPacket> deserializer = ETHERTYPE_DESERIALIZER_MAP.containsKey(ethType) ? ETHERTYPE_DESERIALIZER_MAP.get(ethType) : Data.deserializer();
            Data payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            payload.setParent(eth);
            eth.setPayload(payload);
            return eth;
        };
    }

    public Ethernet duplicate() {
        try {
            byte[] data = this.serialize();
            return Ethernet.deserializer().deserialize(data, 0, data.length);
        }
        catch (DeserializationException dex) {
            throw new IllegalStateException(dex);
        }
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EthType.EtherType ethType : EthType.EtherType.values()) {
            if (ethType.deserializer() == null) continue;
            builder.put((Object)ethType.ethType().toShort(), ethType.deserializer());
        }
        ETHERTYPE_DESERIALIZER_MAP = builder.build();
    }
}

