/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.onlab.util.Tools;

public final class SlidingWindowCounter {
    private volatile int headSlot;
    private final int windowSlots;
    private final List<AtomicLong> counters;
    private final ScheduledExecutorService background;
    private final AtomicLong totalCount = new AtomicLong();
    private final AtomicLong totalSlots = new AtomicLong(1L);
    private static final int SLIDE_WINDOW_PERIOD_SECONDS = 1;

    public SlidingWindowCounter(int windowSlots) {
        Preconditions.checkArgument((windowSlots > 0 ? 1 : 0) != 0, (Object)"Window size must be a positive integer");
        this.windowSlots = windowSlots;
        this.headSlot = 0;
        this.counters = ImmutableList.copyOf((Collection)IntStream.range(0, windowSlots).mapToObj(i -> new AtomicLong()).collect(Collectors.toList()));
        this.background = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads("SlidingWindowCounter", "bg-%d"));
        this.background.scheduleWithFixedDelay(this::advanceHead, 1L, 1L, TimeUnit.SECONDS);
    }

    public void destroy() {
        this.background.shutdownNow();
    }

    public void incrementCount() {
        this.incrementCount(this.headSlot, 1L);
    }

    public void incrementCount(long value) {
        this.incrementCount(this.headSlot, value);
    }

    private void incrementCount(int slot, long value) {
        this.counters.get(slot).addAndGet(value);
        this.totalCount.addAndGet(value);
    }

    @Deprecated
    public long get(int slots) {
        return this.getWindowCount(slots);
    }

    public long getWindowCount() {
        return this.getWindowCount(this.windowSlots);
    }

    public long getWindowCount(int slots) {
        Preconditions.checkArgument((slots <= this.windowSlots ? 1 : 0) != 0, (Object)"Requested window must be less than the total window slots");
        long sum = 0L;
        slots = this.getMinSlots(slots);
        for (int i = 0; i < slots; ++i) {
            int currentIndex = this.headSlot - i;
            if (currentIndex < 0) {
                currentIndex = this.counters.size() + currentIndex;
            }
            sum += this.counters.get(currentIndex).get();
        }
        return sum;
    }

    public double getWindowRate() {
        return this.getWindowRate(this.windowSlots);
    }

    public double getWindowRate(int slots) {
        slots = this.getMinSlots(slots);
        return (double)this.getWindowCount(slots) / (double)slots;
    }

    private int getMinSlots(int slots) {
        return Math.min(slots, (int)Math.min(this.totalSlots.get(), Integer.MAX_VALUE));
    }

    public long getOverallCount() {
        return this.totalCount.get();
    }

    public double getOverallRate() {
        return (double)this.totalCount.get() / (double)this.totalSlots.get();
    }

    public void clear() {
        this.counters.forEach(value -> value.set(0L));
        this.totalCount.set(0L);
        this.totalSlots.set(1L);
        this.headSlot = 0;
    }

    void advanceHead() {
        this.counters.get(this.slotAfter(this.headSlot)).set(0L);
        this.headSlot = this.slotAfter(this.headSlot);
        this.totalSlots.incrementAndGet();
    }

    private int slotAfter(int slot) {
        return (slot + 1) % this.windowSlots;
    }
}

