/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.DHCP6;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.dhcp.Dhcp6IaAddressOption;
import org.onlab.packet.dhcp.Dhcp6Option;

public final class Dhcp6LeaseQueryOption
extends Dhcp6Option {
    public static final int DEFAULT_LEN = 17;
    public Ip6Address linkAddress;
    private List<Dhcp6Option> options = Lists.newArrayList();
    public byte queryType;

    public Dhcp6LeaseQueryOption(Dhcp6Option dhcp6Option) {
        super(dhcp6Option);
    }

    @Override
    public short getCode() {
        return DHCP6.OptionCode.LEASE_QUERY.value();
    }

    @Override
    public short getLength() {
        return (short)(17 + this.options.stream().mapToInt(opt -> opt.getLength() + 4).sum());
    }

    @Override
    public byte[] getData() {
        return this.payload.serialize();
    }

    public static Deserializer<Dhcp6Option> deserializer() {
        return (data, offset, length) -> {
            Dhcp6Option dhcp6Option = Dhcp6Option.deserializer().deserialize(data, offset, length);
            Dhcp6LeaseQueryOption lQ6Option = new Dhcp6LeaseQueryOption(dhcp6Option);
            byte[] optionData = lQ6Option.getData();
            if (optionData.length >= 17) {
                ByteBuffer bb = ByteBuffer.wrap(optionData);
                lQ6Option.queryType = bb.get();
                byte[] ipv6Addr = new byte[16];
                bb.get(ipv6Addr);
                lQ6Option.linkAddress = Ip6Address.valueOf(ipv6Addr);
                lQ6Option.options = Lists.newArrayList();
                while (bb.remaining() >= 4) {
                    ByteBuffer optByteBuffer = ByteBuffer.wrap(optionData, bb.position(), optionData.length - bb.position());
                    short code = optByteBuffer.getShort();
                    short len = optByteBuffer.getShort();
                    int optLen = 0xFFFF & len;
                    byte[] subOptData = new byte[4 + optLen];
                    bb.get(subOptData);
                    Dhcp6Option option = code == DHCP6.OptionCode.IAADDR.value() ? Dhcp6IaAddressOption.deserializer().deserialize(subOptData, 0, subOptData.length) : (code == DHCP6.OptionCode.ORO.value() ? Dhcp6Option.deserializer().deserialize(subOptData, 0, subOptData.length) : Dhcp6Option.deserializer().deserialize(subOptData, 0, subOptData.length));
                    lQ6Option.options.add(option);
                }
            }
            return lQ6Option;
        };
    }

    @Override
    public byte[] serialize() {
        byte[] serializedPayload = this.payload.serialize();
        ByteBuffer bb = ByteBuffer.allocate(serializedPayload.length + 4);
        bb.putShort(this.getCode());
        bb.putShort(this.getLength());
        bb.put(serializedPayload);
        return bb.array();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("code", (int)this.getCode()).add("length", (int)this.getLength()).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.linkAddress, this.options);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dhcp6LeaseQueryOption)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Dhcp6LeaseQueryOption other = (Dhcp6LeaseQueryOption)obj;
        return Objects.equals(this.getCode(), other.getCode()) && Objects.equals(this.getLength(), other.getLength()) && Objects.equals(this.linkAddress, other.linkAddress) && Objects.equals(this.options, other.options);
    }
}

