/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.GraphTest;
import org.onlab.graph.TarjanGraphSearch;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;

public class TarjanGraphSearchTest
extends GraphTest {
    private void validate(TarjanGraphSearch.SccResult<TestVertex, TestEdge> result, int cc) {
        System.out.println("Cluster count: " + result.clusterVertexes().size());
        System.out.println("Clusters: " + result.clusterVertexes());
        Assert.assertEquals((String)"incorrect cluster count", (long)cc, (long)result.clusterCount());
    }

    private void validate(TarjanGraphSearch.SccResult<TestVertex, TestEdge> result, int i, int vc, int ec) {
        Assert.assertEquals((String)"incorrect cluster count", (long)vc, (long)((Set)result.clusterVertexes().get(i)).size());
        Assert.assertEquals((String)"incorrect edge count", (long)ec, (long)((Set)result.clusterEdges().get(i)).size());
    }

    @Test
    public void basic() {
        this.graph = new AdjacencyListsGraph(this.vertexes(), this.edges());
        TarjanGraphSearch gs = new TarjanGraphSearch();
        TarjanGraphSearch.SccResult result = gs.search(this.graph, null);
        this.validate((TarjanGraphSearch.SccResult<TestVertex, TestEdge>)result, 6);
    }

    @Test
    public void singleCluster() {
        this.graph = new AdjacencyListsGraph(this.vertexes(), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B)), (Object)((Object)new TestEdge(B, C)), (Object)((Object)new TestEdge(C, D)), (Object)((Object)new TestEdge(D, E)), (Object)((Object)new TestEdge(E, F)), (Object)((Object)new TestEdge(F, G)), (Object[])new TestEdge[]{new TestEdge(G, H), new TestEdge(H, A)}));
        TarjanGraphSearch gs = new TarjanGraphSearch();
        TarjanGraphSearch.SccResult result = gs.search(this.graph, null);
        this.validate((TarjanGraphSearch.SccResult<TestVertex, TestEdge>)result, 1);
        this.validate((TarjanGraphSearch.SccResult<TestVertex, TestEdge>)result, 0, 8, 8);
    }

    @Test
    public void twoUnconnectedCluster() {
        this.graph = new AdjacencyListsGraph(this.vertexes(), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B)), (Object)((Object)new TestEdge(B, C)), (Object)((Object)new TestEdge(C, D)), (Object)((Object)new TestEdge(D, A)), (Object)((Object)new TestEdge(E, F)), (Object)((Object)new TestEdge(F, G)), (Object[])new TestEdge[]{new TestEdge(G, H), new TestEdge(H, E)}));
        TarjanGraphSearch gs = new TarjanGraphSearch();
        TarjanGraphSearch.SccResult result = gs.search(this.graph, null);
        this.validate((TarjanGraphSearch.SccResult<TestVertex, TestEdge>)result, 2);
        this.validate((TarjanGraphSearch.SccResult<TestVertex, TestEdge>)result, 0, 4, 4);
        this.validate((TarjanGraphSearch.SccResult<TestVertex, TestEdge>)result, 1, 4, 4);
    }

    @Test
    public void twoWeaklyConnectedClusters() {
        this.graph = new AdjacencyListsGraph(this.vertexes(), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B)), (Object)((Object)new TestEdge(B, C)), (Object)((Object)new TestEdge(C, D)), (Object)((Object)new TestEdge(D, A)), (Object)((Object)new TestEdge(E, F)), (Object)((Object)new TestEdge(F, G)), (Object[])new TestEdge[]{new TestEdge(G, H), new TestEdge(H, E), new TestEdge(B, E)}));
        TarjanGraphSearch gs = new TarjanGraphSearch();
        TarjanGraphSearch.SccResult result = gs.search(this.graph, null);
        this.validate((TarjanGraphSearch.SccResult<TestVertex, TestEdge>)result, 2);
        this.validate((TarjanGraphSearch.SccResult<TestVertex, TestEdge>)result, 0, 4, 4);
        this.validate((TarjanGraphSearch.SccResult<TestVertex, TestEdge>)result, 1, 4, 4);
    }

    @Test
    public void twoClustersConnectedWithIgnoredEdges() {
        this.graph = new AdjacencyListsGraph(this.vertexes(), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B)), (Object)((Object)new TestEdge(B, C)), (Object)((Object)new TestEdge(C, D)), (Object)((Object)new TestEdge(D, A)), (Object)((Object)new TestEdge(E, F)), (Object)((Object)new TestEdge(F, G)), (Object[])new TestEdge[]{new TestEdge(G, H), new TestEdge(H, E), new TestEdge(B, E, this.weigher.getNonViableWeight()), new TestEdge(E, B, this.weigher.getNonViableWeight())}));
        TarjanGraphSearch gs = new TarjanGraphSearch();
        TarjanGraphSearch.SccResult result = gs.search(this.graph, this.weigher);
        this.validate((TarjanGraphSearch.SccResult<TestVertex, TestEdge>)result, 2);
        this.validate((TarjanGraphSearch.SccResult<TestVertex, TestEdge>)result, 0, 4, 4);
        this.validate((TarjanGraphSearch.SccResult<TestVertex, TestEdge>)result, 1, 4, 4);
    }
}

