/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ipv6;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.Data;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.UDP;
import org.onlab.packet.ipv6.BaseOptions;

public class BaseOptionsTest {
    private static Data data;
    private static UDP udp;
    private static byte[] options;
    private static byte[] bytePacket;
    private Deserializer<BaseOptions> deserializer;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        data = new Data();
        data.setData("testSerialize".getBytes());
        udp = new UDP();
        udp.setPayload((IPacket)data);
        byte[] bytePayload = udp.serialize();
        byte[] byteHeader = new byte[]{17, 0, 0, 3, -1, -1, -1, 0};
        bytePacket = new byte[byteHeader.length + bytePayload.length];
        System.arraycopy(byteHeader, 0, bytePacket, 0, byteHeader.length);
        System.arraycopy(bytePayload, 0, bytePacket, byteHeader.length, bytePayload.length);
    }

    @Before
    public void setUp() {
        this.deserializer = BaseOptions.deserializer();
    }

    @Test
    public void testSerialize() {
        BaseOptions baseopt = new BaseOptions();
        baseopt.setNextHeader((byte)17);
        baseopt.setHeaderExtLength((byte)0);
        baseopt.setOptions(options);
        baseopt.setPayload((IPacket)udp);
        Assert.assertArrayEquals((byte[])baseopt.serialize(), (byte[])bytePacket);
    }

    @Test
    public void testDeserialize() throws Exception {
        BaseOptions baseopt = (BaseOptions)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        Assert.assertThat((Object)baseopt.getNextHeader(), (Matcher)Matchers.is((Object)17));
        Assert.assertThat((Object)baseopt.getHeaderExtLength(), (Matcher)Matchers.is((Object)0));
        Assert.assertArrayEquals((byte[])baseopt.getOptions(), (byte[])options);
    }

    @Test
    public void testEqual() {
        BaseOptions baseopt1 = new BaseOptions();
        baseopt1.setNextHeader((byte)17);
        baseopt1.setHeaderExtLength((byte)0);
        baseopt1.setOptions(options);
        baseopt1.setType((byte)0);
        BaseOptions baseopt2 = new BaseOptions();
        baseopt2.setNextHeader((byte)17);
        baseopt2.setHeaderExtLength((byte)0);
        baseopt2.setOptions(options);
        baseopt1.setType((byte)60);
        Assert.assertTrue((boolean)baseopt1.equals((Object)baseopt1));
        Assert.assertFalse((boolean)baseopt1.equals((Object)baseopt2));
    }

    @Test
    public void testToStringBaseOptions() throws Exception {
        BaseOptions baseopt = (BaseOptions)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        String str = baseopt.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"nextHeader=17"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"headerExtLength=0"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("options=" + Arrays.toString(options))));
    }

    static {
        options = new byte[]{0, 3, -1, -1, -1, 0};
    }
}

