/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.onlab.util.HexString;

public final class ImmutableByteSequence {
    private ByteBuffer value;

    private ImmutableByteSequence(ByteBuffer value) {
        this.value = value;
        this.value.rewind();
    }

    public static ImmutableByteSequence copyFrom(byte[] original) {
        Preconditions.checkArgument((original != null && original.length > 0 ? 1 : 0) != 0, (Object)"Cannot copy from an empty or null array");
        return new ImmutableByteSequence(ByteBuffer.allocate(original.length).put(original));
    }

    public static ImmutableByteSequence copyFrom(byte[] original, int fromIdx, int toIdx) {
        Preconditions.checkArgument((original != null && original.length > 0 ? 1 : 0) != 0, (Object)"Cannot copy from an empty or null array");
        Preconditions.checkArgument((toIdx >= fromIdx && toIdx < original.length ? 1 : 0) != 0, (Object)"invalid indexes");
        ByteBuffer buffer = ByteBuffer.allocate(toIdx - fromIdx + 1);
        for (int i = fromIdx; i <= toIdx; ++i) {
            buffer.put(original[i]);
        }
        return new ImmutableByteSequence(buffer);
    }

    public static ImmutableByteSequence copyFrom(ByteBuffer original) {
        Preconditions.checkArgument((original != null && original.capacity() > 0 ? 1 : 0) != 0, (Object)"Cannot copy from an empty or null byte buffer");
        byte[] bytes = new byte[original.capacity()];
        original.rewind();
        original.get(bytes);
        if (original.order() == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])bytes);
        }
        return new ImmutableByteSequence(ByteBuffer.wrap(bytes));
    }

    public static ImmutableByteSequence copyFrom(long original) {
        return new ImmutableByteSequence(ByteBuffer.allocate(8).putLong(original));
    }

    public static ImmutableByteSequence copyFrom(int original) {
        return new ImmutableByteSequence(ByteBuffer.allocate(4).putInt(original));
    }

    public static ImmutableByteSequence copyFrom(short original) {
        return new ImmutableByteSequence(ByteBuffer.allocate(2).putShort(original));
    }

    public static ImmutableByteSequence copyFrom(byte original) {
        return new ImmutableByteSequence(ByteBuffer.allocate(1).put(original));
    }

    public static ImmutableByteSequence ofZeros(int size) {
        return new ImmutableByteSequence(ByteBuffer.wrap(new byte[size]));
    }

    public static ImmutableByteSequence ofOnes(int size) {
        byte[] bytes = new byte[size];
        Arrays.fill(bytes, (byte)-1);
        return new ImmutableByteSequence(ByteBuffer.wrap(bytes));
    }

    static ImmutableByteSequence prefix(int size, long prefixBits, byte val) {
        Preconditions.checkArgument((val == 0 || val == -1 ? 1 : 0) != 0, (Object)"Val must be 0 or 0xff");
        byte[] bytes = new byte[size];
        int prefixBytes = (int)(prefixBits / 8L);
        Arrays.fill(bytes, 0, prefixBytes, val);
        Arrays.fill(bytes, prefixBytes, bytes.length, ~val);
        int partialBits = (int)(prefixBits % 8L);
        if (partialBits != 0) {
            bytes[prefixBytes] = val == 0 ? (byte)(255 >> partialBits) : (byte)(255 << 8 - partialBits);
        }
        return new ImmutableByteSequence(ByteBuffer.wrap(bytes));
    }

    public static ImmutableByteSequence prefixZeros(int size, long prefixBits) {
        return ImmutableByteSequence.prefix(size, prefixBits, (byte)0);
    }

    public static ImmutableByteSequence prefixOnes(int size, long prefixBits) {
        return ImmutableByteSequence.prefix(size, prefixBits, (byte)-1);
    }

    public ByteBuffer asReadOnlyBuffer() {
        return this.value.asReadOnlyBuffer();
    }

    public int size() {
        return this.value.capacity();
    }

    public byte[] asArray() {
        ByteBuffer bb = this.asReadOnlyBuffer();
        byte[] bytes = new byte[this.size()];
        bb.get(bytes);
        return bytes;
    }

    private ImmutableByteSequence doBitwiseOp(ImmutableByteSequence other, BitwiseOp op) {
        Preconditions.checkArgument((other != null && this.size() == other.size() ? 1 : 0) != 0, (Object)"Other sequence must be non null and with same size as this");
        byte[] newBytes = new byte[this.size()];
        byte[] thisBytes = this.asArray();
        byte[] otherBytes = other.asArray();
        block5: for (int i = 0; i < this.size(); ++i) {
            switch (op) {
                case AND: {
                    newBytes[i] = (byte)(thisBytes[i] & otherBytes[i]);
                    continue block5;
                }
                case OR: {
                    newBytes[i] = (byte)(thisBytes[i] | otherBytes[i]);
                    continue block5;
                }
                case XOR: {
                    newBytes[i] = (byte)(thisBytes[i] ^ otherBytes[i]);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown bitwise operator " + op.name());
                }
            }
        }
        return ImmutableByteSequence.copyFrom(newBytes);
    }

    public ImmutableByteSequence bitwiseAnd(ImmutableByteSequence other) {
        return this.doBitwiseOp(other, BitwiseOp.AND);
    }

    public ImmutableByteSequence bitwiseOr(ImmutableByteSequence other) {
        return this.doBitwiseOp(other, BitwiseOp.OR);
    }

    public ImmutableByteSequence bitwiseXor(ImmutableByteSequence other) {
        return this.doBitwiseOp(other, BitwiseOp.XOR);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableByteSequence other = (ImmutableByteSequence)obj;
        return Objects.equal((Object)this.value, (Object)other.value);
    }

    public int msbIndex() {
        int index = this.size() * 8 - 1;
        block0: for (int i = 0; i < this.size(); ++i) {
            byte b = this.value.get(i);
            if (b != 0) {
                for (int j = 7; j >= 0; --j) {
                    byte mask = (byte)((1 << j) - 1);
                    if ((b & ~mask) != 0) break block0;
                    --index;
                }
            }
            index -= 8;
        }
        return index;
    }

    public String toString() {
        return HexString.toHexString(this.value.array());
    }

    public ImmutableByteSequence fit(int bitWidth) throws ByteSequenceTrimException {
        return ImmutableByteSequence.doFit(this, bitWidth);
    }

    @Deprecated
    public static ImmutableByteSequence fit(ImmutableByteSequence original, int bitWidth) throws ByteSequenceTrimException {
        return ImmutableByteSequence.doFit(original, bitWidth);
    }

    private static ImmutableByteSequence doFit(ImmutableByteSequence original, int bitWidth) throws ByteSequenceTrimException {
        Preconditions.checkNotNull((Object)original, (Object)"byte sequence cannot be null");
        Preconditions.checkArgument((bitWidth > 0 ? 1 : 0) != 0, (Object)"bit-width must be a non-zero positive integer");
        int newByteWidth = (int)Math.ceil((double)bitWidth / 8.0);
        if (bitWidth == original.size() * 8) {
            return original;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(newByteWidth);
        if (newByteWidth > original.size()) {
            int numPadBytes = newByteWidth - original.size();
            for (int i = 0; i < numPadBytes; ++i) {
                newBuffer.put((byte)0);
            }
            newBuffer.put(original.asReadOnlyBuffer());
        } else if (bitWidth > original.msbIndex()) {
            int diff = original.size() - newByteWidth;
            ByteBuffer originalBuffer = original.asReadOnlyBuffer();
            for (int i = diff; i < original.size(); ++i) {
                newBuffer.put(originalBuffer.get(i));
            }
        } else {
            throw new ByteSequenceTrimException(original, bitWidth);
        }
        return new ImmutableByteSequence(newBuffer);
    }

    public static class ByteSequenceTrimException
    extends Exception {
        ByteSequenceTrimException(ImmutableByteSequence original, int bitWidth) {
            super(String.format("cannot trim %s into a %d bits long value", original, bitWidth));
        }
    }

    private static enum BitwiseOp {
        AND,
        OR,
        XOR;

    }
}

