/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.LLDP;
import org.onlab.packet.LLDPTLV;
import org.onlab.packet.PacketTestUtils;

public class LLDPTest {
    private Deserializer<LLDP> deserializer;
    private byte[] chassisValue = new byte[]{1, 2, 3, 4, 5, 6, 7};
    private byte[] portValue = new byte[]{1, 2, 3, 4, 5};
    private byte[] ttlValue = new byte[]{0, 32};
    private short optionalTlvSize = (short)6;
    private byte[] optionalTlvValue = new byte[]{6, 5, 4, 3, 2, 1};
    private byte[] bytes;

    @Before
    public void setUp() throws Exception {
        this.deserializer = LLDP.deserializer();
        ByteBuffer bb = ByteBuffer.allocate(22 + this.optionalTlvSize + 2);
        bb.putShort(this.getTypeLength((byte)1, (short)7));
        bb.put(this.chassisValue);
        bb.putShort(this.getTypeLength((byte)2, (short)5));
        bb.put(this.portValue);
        bb.putShort(this.getTypeLength((byte)3, (short)2));
        bb.put(this.ttlValue);
        bb.putShort(this.getTypeLength((byte)127, this.optionalTlvSize));
        bb.put(this.optionalTlvValue);
        bb.putShort((short)0);
        this.bytes = bb.array();
    }

    private short getTypeLength(byte type, short length) {
        return (short)((0x7F & type) << 9 | 0x1FF & length);
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.bytes);
    }

    @Test
    public void testDeserialize() throws Exception {
        LLDP lldp = (LLDP)this.deserializer.deserialize(this.bytes, 0, this.bytes.length);
        Assert.assertEquals((long)1L, (long)lldp.getChassisId().getType());
        Assert.assertEquals((long)7L, (long)lldp.getChassisId().getLength());
        Assert.assertTrue((boolean)Arrays.equals(this.chassisValue, lldp.getChassisId().getValue()));
        Assert.assertEquals((long)2L, (long)lldp.getPortId().getType());
        Assert.assertEquals((long)5L, (long)lldp.getPortId().getLength());
        Assert.assertTrue((boolean)Arrays.equals(this.portValue, lldp.getPortId().getValue()));
        Assert.assertEquals((long)3L, (long)lldp.getTtl().getType());
        Assert.assertEquals((long)2L, (long)lldp.getTtl().getLength());
        Assert.assertTrue((boolean)Arrays.equals(this.ttlValue, lldp.getTtl().getValue()));
        Assert.assertEquals((long)1L, (long)lldp.getOptionalTLVList().size());
        LLDPTLV optionalTlv = (LLDPTLV)lldp.getOptionalTLVList().get(0);
        Assert.assertEquals((long)127L, (long)optionalTlv.getType());
        Assert.assertEquals((long)this.optionalTlvSize, (long)optionalTlv.getLength());
        Assert.assertTrue((boolean)Arrays.equals(this.optionalTlvValue, optionalTlv.getValue()));
    }

    @Test
    public void testToStringLLDP() throws Exception {
        LLDP lldp = (LLDP)this.deserializer.deserialize(this.bytes, 0, this.bytes.length);
        String str = lldp.toString();
    }
}

