/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.math.DoubleMath;
import java.util.Objects;
import org.onlab.graph.Weight;

public class TestDoubleWeight
implements Weight {
    public static final TestDoubleWeight NEGATIVE_WEIGHT = new TestDoubleWeight(-1.0);
    public static final TestDoubleWeight NON_VIABLE_WEIGHT = new TestDoubleWeight(Double.POSITIVE_INFINITY);
    private final double value;

    public TestDoubleWeight(double value) {
        this.value = value;
    }

    public Weight merge(Weight otherWeight) {
        return new TestDoubleWeight(this.value + ((TestDoubleWeight)otherWeight).value);
    }

    public Weight subtract(Weight otherWeight) {
        return new TestDoubleWeight(this.value - ((TestDoubleWeight)otherWeight).value);
    }

    public boolean isViable() {
        return !this.equals(NON_VIABLE_WEIGHT);
    }

    public int compareTo(Weight otherWeight) {
        return Double.compare(this.value, ((TestDoubleWeight)otherWeight).value);
    }

    public boolean equals(Object obj) {
        return DoubleMath.fuzzyEquals((double)this.value, (double)((TestDoubleWeight)obj).value, (double)0.1);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean isNegative() {
        return this.value < 0.0;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

