/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.DHCP6;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.UDP;
import org.onlab.packet.dhcp.Dhcp6ClientIdOption;
import org.onlab.packet.dhcp.Dhcp6Duid;
import org.onlab.packet.dhcp.Dhcp6IaAddressOption;
import org.onlab.packet.dhcp.Dhcp6IaNaOption;
import org.onlab.packet.dhcp.Dhcp6Option;
import org.onlab.packet.dhcp.Dhcp6RelayOption;

public class Dhcp6RelayTest {
    private static final String SOLICIT = "dhcp6_relay_solicit.bin";
    private static final String ADVERTISE = "dhcp6_relay_advertise.bin";
    private static final String REQUEST = "dhcp6_relay_request.bin";
    private static final String REPLY = "dhcp6_relay_reply.bin";
    private static final int HOP_COUNT = 0;
    private static final Ip6Address LINK_ADDRESS = Ip6Address.valueOf((String)"2000::2ff");
    private static final Ip6Address PEER_ADDRESS = Ip6Address.valueOf((String)"fe80::2bb:ff:fe00:1");
    private static final int XID_1 = 8135067;
    private static final int XID_2 = 14742082;
    private static final int IA_ID = 1;
    private static final int T1_CLIENT = 3600;
    private static final int T2_CLIENT = 5400;
    private static final int T1_SERVER = 0;
    private static final int T2_SERVER = 0;
    private static final Ip6Address IA_ADDRESS = Ip6Address.valueOf((String)"2000::201");
    private static final int PREFFERRED_LT_SERVER = 375;
    private static final int VALID_LT_SERVER = 600;
    private static final int PREFFERRED_LT_REQ = 7200;
    private static final int VALID_LT_REQ = 10800;
    private static final int VALID_LT_REQ_2 = 7500;
    private static final MacAddress DOWNSTREAM_MAC = MacAddress.valueOf((String)"4a:c0:c2:78:92:34");
    private static final MacAddress CLIENT_MAC = MacAddress.valueOf((String)"00:bb:00:00:00:01");
    private static final int CLIENT_DUID_TIME = 555636143;
    private static final MacAddress IPV6_MCAST = MacAddress.valueOf((String)"33:33:00:01:00:03");
    private static final Ip6Address DOWNSTREAM_LL = Ip6Address.valueOf((String)"fe80::48c0:c2ff:fe78:9234");
    private static final Ip6Address DHCP6_BRC = Ip6Address.valueOf((String)"ff05::1:3");
    private static final Ip6Address SERVER_IP = Ip6Address.valueOf((String)"2000::9903");
    private static final MacAddress SERVER_MAC = MacAddress.valueOf((String)"00:99:66:00:00:01");
    private static final Ip6Address SERVER_LL = Ip6Address.valueOf((String)"fe80::299:66ff:fe00:1");

    @Test
    public void deserializeSolicit() throws Exception {
        byte[] data = Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(SOLICIT));
        Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(data, 0, data.length);
        DHCP6 relayMsg = (DHCP6)eth.getPayload().getPayload().getPayload();
        Assert.assertEquals((long)relayMsg.getMsgType(), (long)DHCP6.MsgType.RELAY_FORW.value());
        Assert.assertEquals((long)relayMsg.getHopCount(), (long)0L);
        Assert.assertEquals((Object)relayMsg.getIp6LinkAddress(), (Object)LINK_ADDRESS);
        Assert.assertEquals((Object)relayMsg.getIp6PeerAddress(), (Object)PEER_ADDRESS);
        Assert.assertEquals((long)relayMsg.getOptions().size(), (long)2L);
        Dhcp6Option option = (Dhcp6Option)relayMsg.getOptions().get(0);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.SUBSCRIBER_ID.value());
        Assert.assertEquals((long)option.getLength(), (long)10L);
        Assert.assertArrayEquals((byte[])option.getData(), (byte[])SERVER_IP.toString().getBytes(StandardCharsets.US_ASCII));
        option = (Dhcp6Option)relayMsg.getOptions().get(1);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.RELAY_MSG.value());
        Assert.assertEquals((long)option.getLength(), (long)84L);
        Assert.assertTrue((boolean)(option.getPayload() instanceof DHCP6));
        DHCP6 relaiedDhcp6 = (DHCP6)option.getPayload();
        Assert.assertEquals((long)relaiedDhcp6.getMsgType(), (long)DHCP6.MsgType.SOLICIT.value());
        Assert.assertEquals((long)relaiedDhcp6.getTransactionId(), (long)8135067L);
        Assert.assertEquals((long)relaiedDhcp6.getOptions().size(), (long)4L);
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(0);
        Assert.assertTrue((boolean)(option instanceof Dhcp6ClientIdOption));
        Dhcp6ClientIdOption clientIdOption = (Dhcp6ClientIdOption)option;
        Assert.assertEquals((long)clientIdOption.getCode(), (long)DHCP6.OptionCode.CLIENTID.value());
        Assert.assertEquals((long)clientIdOption.getLength(), (long)14L);
        Assert.assertEquals((Object)clientIdOption.getDuid().getDuidType(), (Object)Dhcp6Duid.DuidType.DUID_LLT);
        Assert.assertEquals((long)clientIdOption.getDuid().getHardwareType(), (long)1L);
        Assert.assertEquals((long)clientIdOption.getDuid().getDuidTime(), (long)555636143L);
        Assert.assertArrayEquals((byte[])clientIdOption.getDuid().getLinkLayerAddress(), (byte[])CLIENT_MAC.toBytes());
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(1);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.ORO.value());
        Assert.assertEquals((long)option.getLength(), (long)8L);
        Assert.assertArrayEquals((byte[])option.getData(), (byte[])new byte[]{0, 23, 0, 24, 0, 39, 0, 31});
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(2);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.ELAPSED_TIME.value());
        Assert.assertEquals((long)option.getLength(), (long)2L);
        Assert.assertArrayEquals((byte[])option.getData(), (byte[])new byte[]{0, 0});
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(3);
        Assert.assertTrue((boolean)(option instanceof Dhcp6IaNaOption));
        Dhcp6IaNaOption iaNaOption = (Dhcp6IaNaOption)option;
        Assert.assertEquals((long)iaNaOption.getCode(), (long)DHCP6.OptionCode.IA_NA.value());
        Assert.assertEquals((long)iaNaOption.getLength(), (long)40L);
        Assert.assertEquals((long)iaNaOption.getIaId(), (long)1L);
        Assert.assertEquals((long)iaNaOption.getT1(), (long)3600L);
        Assert.assertEquals((long)iaNaOption.getT2(), (long)5400L);
        Assert.assertEquals((long)iaNaOption.getOptions().size(), (long)1L);
        Dhcp6IaAddressOption subOption = (Dhcp6IaAddressOption)iaNaOption.getOptions().get(0);
        Assert.assertEquals((Object)subOption.getIp6Address(), (Object)IA_ADDRESS);
        Assert.assertEquals((long)subOption.getPreferredLifetime(), (long)7200L);
        Assert.assertEquals((long)subOption.getValidLifetime(), (long)10800L);
        Assert.assertArrayEquals((byte[])data, (byte[])eth.serialize());
    }

    @Test
    public void serializeSolicit() throws Exception {
        DHCP6 relayMsg = new DHCP6();
        relayMsg.setMsgType(DHCP6.MsgType.RELAY_FORW.value());
        relayMsg.setHopCount((byte)0);
        relayMsg.setLinkAddress(LINK_ADDRESS.toOctets());
        relayMsg.setPeerAddress(PEER_ADDRESS.toOctets());
        DHCP6 relaiedDhcp6 = new DHCP6();
        relaiedDhcp6.setMsgType(DHCP6.MsgType.SOLICIT.value());
        relaiedDhcp6.setTransactionId(8135067);
        ArrayList options = Lists.newArrayList();
        Dhcp6Duid duid = new Dhcp6Duid();
        duid.setDuidType(Dhcp6Duid.DuidType.DUID_LLT);
        duid.setHardwareType((short)1);
        duid.setDuidTime(555636143);
        duid.setLinkLayerAddress(CLIENT_MAC.toBytes());
        Dhcp6ClientIdOption clientIdOption = new Dhcp6ClientIdOption();
        clientIdOption.setDuid(duid);
        options.add(clientIdOption);
        Dhcp6Option option = new Dhcp6Option();
        option.setCode(DHCP6.OptionCode.ORO.value());
        option.setLength((short)8);
        option.setData(new byte[]{0, 23, 0, 24, 0, 39, 0, 31});
        options.add(option);
        option = new Dhcp6Option();
        option.setCode(DHCP6.OptionCode.ELAPSED_TIME.value());
        option.setLength((short)2);
        option.setData(new byte[]{0, 0});
        options.add(option);
        Dhcp6IaNaOption iaNaOption = new Dhcp6IaNaOption();
        iaNaOption.setIaId(1);
        iaNaOption.setT1(3600);
        iaNaOption.setT2(5400);
        Dhcp6IaAddressOption iaAddressOption = new Dhcp6IaAddressOption();
        iaAddressOption.setIp6Address(IA_ADDRESS);
        iaAddressOption.setPreferredLifetime(7200);
        iaAddressOption.setValidLifetime(10800);
        iaNaOption.setOptions((List)ImmutableList.of((Object)iaAddressOption));
        options.add(iaNaOption);
        relaiedDhcp6.setOptions((List)options);
        Dhcp6RelayOption relayOption = new Dhcp6RelayOption();
        relayOption.setPayload((IPacket)relaiedDhcp6);
        Dhcp6Option subscriberId = new Dhcp6Option();
        subscriberId.setCode(DHCP6.OptionCode.SUBSCRIBER_ID.value());
        subscriberId.setLength((short)10);
        subscriberId.setData(SERVER_IP.toString().getBytes(StandardCharsets.US_ASCII));
        relayMsg.setOptions((List)ImmutableList.of((Object)subscriberId, (Object)relayOption));
        UDP udp = new UDP();
        udp.setSourcePort(547);
        udp.setDestinationPort(547);
        udp.setPayload((IPacket)relayMsg);
        udp.setChecksum((short)-25959);
        IPv6 ipv6 = new IPv6();
        ipv6.setHopLimit((byte)32);
        ipv6.setSourceAddress(DOWNSTREAM_LL.toOctets());
        ipv6.setDestinationAddress(DHCP6_BRC.toOctets());
        ipv6.setNextHeader((byte)17);
        ipv6.setTrafficClass((byte)0);
        ipv6.setFlowLabel(835428);
        ipv6.setPayload((IPacket)udp);
        Ethernet eth = new Ethernet();
        eth.setDestinationMACAddress(IPV6_MCAST);
        eth.setSourceMACAddress(DOWNSTREAM_MAC);
        eth.setEtherType(Ethernet.TYPE_IPV6);
        eth.setPayload((IPacket)ipv6);
        Assert.assertArrayEquals((byte[])Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(SOLICIT)), (byte[])eth.serialize());
    }

    @Test
    public void deserializeAdvertise() throws Exception {
        byte[] data = Resources.toByteArray((URL)this.getClass().getResource(ADVERTISE));
        Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(data, 0, data.length);
        DHCP6 relayMsg = (DHCP6)eth.getPayload().getPayload().getPayload();
        Assert.assertEquals((long)relayMsg.getMsgType(), (long)DHCP6.MsgType.RELAY_REPL.value());
        Assert.assertEquals((long)relayMsg.getHopCount(), (long)0L);
        Assert.assertEquals((Object)relayMsg.getIp6LinkAddress(), (Object)LINK_ADDRESS);
        Assert.assertEquals((Object)relayMsg.getIp6PeerAddress(), (Object)PEER_ADDRESS);
        Assert.assertEquals((long)relayMsg.getOptions().size(), (long)1L);
        Dhcp6Option option = (Dhcp6Option)relayMsg.getOptions().get(0);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.RELAY_MSG.value());
        Assert.assertEquals((long)option.getLength(), (long)84L);
        Assert.assertTrue((boolean)(option.getPayload() instanceof DHCP6));
        DHCP6 relaiedDhcp6 = (DHCP6)option.getPayload();
        Assert.assertEquals((long)relaiedDhcp6.getMsgType(), (long)DHCP6.MsgType.ADVERTISE.value());
        Assert.assertEquals((long)relaiedDhcp6.getTransactionId(), (long)8135067L);
        Assert.assertEquals((long)relaiedDhcp6.getOptions().size(), (long)3L);
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(0);
        Assert.assertTrue((boolean)(option instanceof Dhcp6IaNaOption));
        Dhcp6IaNaOption iaNaOption = (Dhcp6IaNaOption)option;
        Assert.assertEquals((long)iaNaOption.getCode(), (long)DHCP6.OptionCode.IA_NA.value());
        Assert.assertEquals((long)iaNaOption.getLength(), (long)40L);
        Assert.assertEquals((long)iaNaOption.getIaId(), (long)1L);
        Assert.assertEquals((long)iaNaOption.getT1(), (long)0L);
        Assert.assertEquals((long)iaNaOption.getT2(), (long)0L);
        Assert.assertEquals((long)iaNaOption.getOptions().size(), (long)1L);
        Assert.assertTrue((boolean)(iaNaOption.getOptions().get(0) instanceof Dhcp6IaAddressOption));
        Dhcp6IaAddressOption iaAddressOption = (Dhcp6IaAddressOption)iaNaOption.getOptions().get(0);
        Assert.assertEquals((Object)iaAddressOption.getIp6Address(), (Object)IA_ADDRESS);
        Assert.assertEquals((long)iaAddressOption.getPreferredLifetime(), (long)375L);
        Assert.assertEquals((long)iaAddressOption.getValidLifetime(), (long)600L);
        Assert.assertNull((Object)iaAddressOption.getOptions());
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(1);
        Assert.assertTrue((boolean)(option instanceof Dhcp6ClientIdOption));
        Dhcp6ClientIdOption clientIdOption = (Dhcp6ClientIdOption)option;
        Assert.assertEquals((long)clientIdOption.getCode(), (long)DHCP6.OptionCode.CLIENTID.value());
        Assert.assertEquals((long)clientIdOption.getLength(), (long)14L);
        Assert.assertEquals((Object)clientIdOption.getDuid().getDuidType(), (Object)Dhcp6Duid.DuidType.DUID_LLT);
        Assert.assertEquals((long)clientIdOption.getDuid().getHardwareType(), (long)1L);
        Assert.assertEquals((long)clientIdOption.getDuid().getDuidTime(), (long)555636143L);
        Assert.assertArrayEquals((byte[])clientIdOption.getDuid().getLinkLayerAddress(), (byte[])CLIENT_MAC.toBytes());
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(2);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.SERVERID.value());
        Assert.assertEquals((long)option.getLength(), (long)14L);
        Dhcp6Duid serverDuid = (Dhcp6Duid)Dhcp6Duid.deserializer().deserialize(option.getData(), 0, option.getData().length);
        Assert.assertEquals((Object)serverDuid.getDuidType(), (Object)Dhcp6Duid.DuidType.DUID_LLT);
        Assert.assertEquals((long)serverDuid.getDuidTime(), (long)555635520L);
        Assert.assertEquals((long)serverDuid.getHardwareType(), (long)1L);
        Assert.assertArrayEquals((byte[])serverDuid.getLinkLayerAddress(), (byte[])SERVER_MAC.toBytes());
        Assert.assertArrayEquals((byte[])data, (byte[])eth.serialize());
    }

    @Test
    public void serializeAdvertise() throws Exception {
        DHCP6 relayMsg = new DHCP6();
        relayMsg.setMsgType(DHCP6.MsgType.RELAY_REPL.value());
        relayMsg.setHopCount((byte)0);
        relayMsg.setLinkAddress(LINK_ADDRESS.toOctets());
        relayMsg.setPeerAddress(PEER_ADDRESS.toOctets());
        DHCP6 relaiedDhcp6 = new DHCP6();
        relaiedDhcp6.setMsgType(DHCP6.MsgType.ADVERTISE.value());
        relaiedDhcp6.setTransactionId(8135067);
        ArrayList options = Lists.newArrayList();
        Dhcp6IaAddressOption iaAddressOption = new Dhcp6IaAddressOption();
        iaAddressOption.setIp6Address(IA_ADDRESS);
        iaAddressOption.setPreferredLifetime(375);
        iaAddressOption.setValidLifetime(600);
        Dhcp6IaNaOption iaNaOption = new Dhcp6IaNaOption();
        iaNaOption.setIaId(1);
        iaNaOption.setT1(0);
        iaNaOption.setT2(0);
        iaNaOption.setOptions((List)ImmutableList.of((Object)iaAddressOption));
        options.add(iaNaOption);
        Dhcp6Duid duid = new Dhcp6Duid();
        duid.setDuidType(Dhcp6Duid.DuidType.DUID_LLT);
        duid.setHardwareType((short)1);
        duid.setDuidTime(555636143);
        duid.setLinkLayerAddress(CLIENT_MAC.toBytes());
        Dhcp6ClientIdOption clientIdOption = new Dhcp6ClientIdOption();
        clientIdOption.setDuid(duid);
        options.add(clientIdOption);
        Dhcp6Option option = new Dhcp6Option();
        option.setCode(DHCP6.OptionCode.SERVERID.value());
        option.setLength((short)14);
        Dhcp6Duid serverDuid = new Dhcp6Duid();
        serverDuid.setDuidType(Dhcp6Duid.DuidType.DUID_LLT);
        serverDuid.setLinkLayerAddress(SERVER_MAC.toBytes());
        serverDuid.setHardwareType((short)1);
        serverDuid.setDuidTime(555635520);
        option.setData(serverDuid.serialize());
        options.add(option);
        relaiedDhcp6.setOptions((List)options);
        Dhcp6RelayOption relayOption = new Dhcp6RelayOption();
        relayOption.setPayload((IPacket)relaiedDhcp6);
        relayMsg.setOptions((List)ImmutableList.of((Object)relayOption));
        UDP udp = new UDP();
        udp.setSourcePort(547);
        udp.setDestinationPort(547);
        udp.setPayload((IPacket)relayMsg);
        udp.setChecksum((short)413);
        IPv6 ipv6 = new IPv6();
        ipv6.setHopLimit((byte)64);
        ipv6.setSourceAddress(SERVER_LL.toOctets());
        ipv6.setDestinationAddress(DOWNSTREAM_LL.toOctets());
        ipv6.setNextHeader((byte)17);
        ipv6.setTrafficClass((byte)0);
        ipv6.setFlowLabel(815855);
        ipv6.setPayload((IPacket)udp);
        Ethernet eth = new Ethernet();
        eth.setDestinationMACAddress(DOWNSTREAM_MAC);
        eth.setSourceMACAddress(SERVER_MAC);
        eth.setEtherType(Ethernet.TYPE_IPV6);
        eth.setPayload((IPacket)ipv6);
        Assert.assertArrayEquals((byte[])Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(ADVERTISE)), (byte[])eth.serialize());
    }

    @Test
    public void deserializeRequest() throws Exception {
        byte[] data = Resources.toByteArray((URL)this.getClass().getResource(REQUEST));
        Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(data, 0, data.length);
        DHCP6 relayMsg = (DHCP6)eth.getPayload().getPayload().getPayload();
        Assert.assertEquals((long)relayMsg.getMsgType(), (long)DHCP6.MsgType.RELAY_FORW.value());
        Assert.assertEquals((long)relayMsg.getHopCount(), (long)0L);
        Assert.assertEquals((Object)relayMsg.getIp6LinkAddress(), (Object)LINK_ADDRESS);
        Assert.assertEquals((Object)relayMsg.getIp6PeerAddress(), (Object)PEER_ADDRESS);
        Assert.assertEquals((long)relayMsg.getOptions().size(), (long)2L);
        Dhcp6Option option = (Dhcp6Option)relayMsg.getOptions().get(0);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.SUBSCRIBER_ID.value());
        Assert.assertEquals((long)option.getLength(), (long)10L);
        Assert.assertArrayEquals((byte[])option.getData(), (byte[])SERVER_IP.toString().getBytes(StandardCharsets.US_ASCII));
        option = (Dhcp6Option)relayMsg.getOptions().get(1);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.RELAY_MSG.value());
        Assert.assertEquals((long)option.getLength(), (long)102L);
        Assert.assertTrue((boolean)(option.getPayload() instanceof DHCP6));
        DHCP6 relaiedDhcp6 = (DHCP6)option.getPayload();
        Assert.assertEquals((long)relaiedDhcp6.getMsgType(), (long)DHCP6.MsgType.REQUEST.value());
        Assert.assertEquals((long)relaiedDhcp6.getTransactionId(), (long)14742082L);
        Assert.assertEquals((long)relaiedDhcp6.getOptions().size(), (long)5L);
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(0);
        Assert.assertTrue((boolean)(option instanceof Dhcp6ClientIdOption));
        Dhcp6ClientIdOption clientIdOption = (Dhcp6ClientIdOption)option;
        Assert.assertEquals((long)clientIdOption.getCode(), (long)DHCP6.OptionCode.CLIENTID.value());
        Assert.assertEquals((long)clientIdOption.getLength(), (long)14L);
        Assert.assertEquals((Object)clientIdOption.getDuid().getDuidType(), (Object)Dhcp6Duid.DuidType.DUID_LLT);
        Assert.assertEquals((long)clientIdOption.getDuid().getHardwareType(), (long)1L);
        Assert.assertEquals((long)clientIdOption.getDuid().getDuidTime(), (long)555636143L);
        Assert.assertArrayEquals((byte[])clientIdOption.getDuid().getLinkLayerAddress(), (byte[])CLIENT_MAC.toBytes());
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(1);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.SERVERID.value());
        Assert.assertEquals((long)option.getLength(), (long)14L);
        Dhcp6Duid serverDuid = (Dhcp6Duid)Dhcp6Duid.deserializer().deserialize(option.getData(), 0, option.getData().length);
        Assert.assertEquals((Object)serverDuid.getDuidType(), (Object)Dhcp6Duid.DuidType.DUID_LLT);
        Assert.assertEquals((long)serverDuid.getDuidTime(), (long)555635520L);
        Assert.assertEquals((long)serverDuid.getHardwareType(), (long)1L);
        Assert.assertArrayEquals((byte[])serverDuid.getLinkLayerAddress(), (byte[])SERVER_MAC.toBytes());
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(2);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.ORO.value());
        Assert.assertEquals((long)option.getLength(), (long)8L);
        Assert.assertArrayEquals((byte[])option.getData(), (byte[])new byte[]{0, 23, 0, 24, 0, 39, 0, 31});
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(3);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.ELAPSED_TIME.value());
        Assert.assertEquals((long)option.getLength(), (long)2L);
        Assert.assertArrayEquals((byte[])option.getData(), (byte[])new byte[]{0, 0});
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(4);
        Assert.assertTrue((boolean)(option instanceof Dhcp6IaNaOption));
        Dhcp6IaNaOption iaNaOption = (Dhcp6IaNaOption)option;
        Assert.assertEquals((long)iaNaOption.getCode(), (long)DHCP6.OptionCode.IA_NA.value());
        Assert.assertEquals((long)iaNaOption.getLength(), (long)40L);
        Assert.assertEquals((long)iaNaOption.getIaId(), (long)1L);
        Assert.assertEquals((long)iaNaOption.getT1(), (long)3600L);
        Assert.assertEquals((long)iaNaOption.getT2(), (long)5400L);
        Assert.assertEquals((long)iaNaOption.getOptions().size(), (long)1L);
        Assert.assertTrue((boolean)(iaNaOption.getOptions().get(0) instanceof Dhcp6IaAddressOption));
        Dhcp6IaAddressOption iaAddressOption = (Dhcp6IaAddressOption)iaNaOption.getOptions().get(0);
        Assert.assertEquals((Object)iaAddressOption.getIp6Address(), (Object)IA_ADDRESS);
        Assert.assertEquals((long)iaAddressOption.getPreferredLifetime(), (long)7200L);
        Assert.assertEquals((long)iaAddressOption.getValidLifetime(), (long)7500L);
        Assert.assertNull((Object)iaAddressOption.getOptions());
        Assert.assertArrayEquals((byte[])data, (byte[])eth.serialize());
    }

    @Test
    public void serializeRequest() throws Exception {
        DHCP6 relayMsg = new DHCP6();
        relayMsg.setMsgType(DHCP6.MsgType.RELAY_FORW.value());
        relayMsg.setHopCount((byte)0);
        relayMsg.setLinkAddress(LINK_ADDRESS.toOctets());
        relayMsg.setPeerAddress(PEER_ADDRESS.toOctets());
        DHCP6 relaiedDhcp6 = new DHCP6();
        relaiedDhcp6.setMsgType(DHCP6.MsgType.REQUEST.value());
        relaiedDhcp6.setTransactionId(14742082);
        ArrayList options = Lists.newArrayList();
        Dhcp6Duid duid = new Dhcp6Duid();
        duid.setDuidType(Dhcp6Duid.DuidType.DUID_LLT);
        duid.setHardwareType((short)1);
        duid.setDuidTime(555636143);
        duid.setLinkLayerAddress(CLIENT_MAC.toBytes());
        Dhcp6ClientIdOption clientIdOption = new Dhcp6ClientIdOption();
        clientIdOption.setDuid(duid);
        options.add(clientIdOption);
        Dhcp6Option option = new Dhcp6Option();
        option.setCode(DHCP6.OptionCode.SERVERID.value());
        option.setLength((short)14);
        Dhcp6Duid serverDuid = new Dhcp6Duid();
        serverDuid.setDuidType(Dhcp6Duid.DuidType.DUID_LLT);
        serverDuid.setLinkLayerAddress(SERVER_MAC.toBytes());
        serverDuid.setHardwareType((short)1);
        serverDuid.setDuidTime(555635520);
        option.setData(serverDuid.serialize());
        options.add(option);
        option = new Dhcp6Option();
        option.setCode(DHCP6.OptionCode.ORO.value());
        option.setLength((short)8);
        option.setData(new byte[]{0, 23, 0, 24, 0, 39, 0, 31});
        options.add(option);
        option = new Dhcp6Option();
        option.setCode(DHCP6.OptionCode.ELAPSED_TIME.value());
        option.setLength((short)2);
        option.setData(new byte[]{0, 0});
        options.add(option);
        Dhcp6IaAddressOption iaAddressOption = new Dhcp6IaAddressOption();
        iaAddressOption.setIp6Address(IA_ADDRESS);
        iaAddressOption.setPreferredLifetime(7200);
        iaAddressOption.setValidLifetime(7500);
        Dhcp6IaNaOption iaNaOption = new Dhcp6IaNaOption();
        iaNaOption.setIaId(1);
        iaNaOption.setT1(3600);
        iaNaOption.setT2(5400);
        iaNaOption.setOptions((List)ImmutableList.of((Object)iaAddressOption));
        options.add(iaNaOption);
        relaiedDhcp6.setOptions((List)options);
        Dhcp6Option subscriberId = new Dhcp6Option();
        subscriberId.setCode(DHCP6.OptionCode.SUBSCRIBER_ID.value());
        subscriberId.setLength((short)10);
        subscriberId.setData(SERVER_IP.toString().getBytes(StandardCharsets.US_ASCII));
        Dhcp6RelayOption relayOption = new Dhcp6RelayOption();
        relayOption.setPayload((IPacket)relaiedDhcp6);
        relayMsg.setOptions((List)ImmutableList.of((Object)subscriberId, (Object)relayOption));
        UDP udp = new UDP();
        udp.setSourcePort(547);
        udp.setDestinationPort(547);
        udp.setPayload((IPacket)relayMsg);
        udp.setChecksum((short)-25941);
        IPv6 ipv6 = new IPv6();
        ipv6.setHopLimit((byte)32);
        ipv6.setSourceAddress(DOWNSTREAM_LL.toOctets());
        ipv6.setDestinationAddress(DHCP6_BRC.toOctets());
        ipv6.setNextHeader((byte)17);
        ipv6.setTrafficClass((byte)0);
        ipv6.setFlowLabel(835428);
        ipv6.setPayload((IPacket)udp);
        Ethernet eth = new Ethernet();
        eth.setDestinationMACAddress(IPV6_MCAST);
        eth.setSourceMACAddress(DOWNSTREAM_MAC);
        eth.setEtherType(Ethernet.TYPE_IPV6);
        eth.setPayload((IPacket)ipv6);
        Assert.assertArrayEquals((byte[])Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(REQUEST)), (byte[])eth.serialize());
    }

    @Test
    public void deserializeReply() throws Exception {
        byte[] data = Resources.toByteArray((URL)this.getClass().getResource(REPLY));
        Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(data, 0, data.length);
        DHCP6 relayMsg = (DHCP6)eth.getPayload().getPayload().getPayload();
        Assert.assertEquals((long)relayMsg.getMsgType(), (long)DHCP6.MsgType.RELAY_REPL.value());
        Assert.assertEquals((long)relayMsg.getHopCount(), (long)0L);
        Assert.assertEquals((Object)relayMsg.getIp6LinkAddress(), (Object)LINK_ADDRESS);
        Assert.assertEquals((Object)relayMsg.getIp6PeerAddress(), (Object)PEER_ADDRESS);
        Assert.assertEquals((long)relayMsg.getOptions().size(), (long)1L);
        Dhcp6Option option = (Dhcp6Option)relayMsg.getOptions().get(0);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.RELAY_MSG.value());
        Assert.assertEquals((long)option.getLength(), (long)84L);
        Assert.assertTrue((boolean)(option.getPayload() instanceof DHCP6));
        DHCP6 relaiedDhcp6 = (DHCP6)option.getPayload();
        Assert.assertEquals((long)relaiedDhcp6.getMsgType(), (long)DHCP6.MsgType.REPLY.value());
        Assert.assertEquals((long)relaiedDhcp6.getTransactionId(), (long)14742082L);
        Assert.assertEquals((long)relaiedDhcp6.getOptions().size(), (long)3L);
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(0);
        Assert.assertTrue((boolean)(option instanceof Dhcp6IaNaOption));
        Dhcp6IaNaOption iaNaOption = (Dhcp6IaNaOption)option;
        Assert.assertEquals((long)iaNaOption.getCode(), (long)DHCP6.OptionCode.IA_NA.value());
        Assert.assertEquals((long)iaNaOption.getLength(), (long)40L);
        Assert.assertEquals((long)iaNaOption.getIaId(), (long)1L);
        Assert.assertEquals((long)iaNaOption.getT1(), (long)0L);
        Assert.assertEquals((long)iaNaOption.getT2(), (long)0L);
        Assert.assertEquals((long)iaNaOption.getOptions().size(), (long)1L);
        Assert.assertTrue((boolean)(iaNaOption.getOptions().get(0) instanceof Dhcp6IaAddressOption));
        Dhcp6IaAddressOption iaAddressOption = (Dhcp6IaAddressOption)iaNaOption.getOptions().get(0);
        Assert.assertEquals((Object)iaAddressOption.getIp6Address(), (Object)IA_ADDRESS);
        Assert.assertEquals((long)iaAddressOption.getPreferredLifetime(), (long)375L);
        Assert.assertEquals((long)iaAddressOption.getValidLifetime(), (long)600L);
        Assert.assertNull((Object)iaAddressOption.getOptions());
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(1);
        Assert.assertTrue((boolean)(option instanceof Dhcp6ClientIdOption));
        Dhcp6ClientIdOption clientIdOption = (Dhcp6ClientIdOption)option;
        Assert.assertEquals((long)clientIdOption.getCode(), (long)DHCP6.OptionCode.CLIENTID.value());
        Assert.assertEquals((long)clientIdOption.getLength(), (long)14L);
        Assert.assertEquals((Object)clientIdOption.getDuid().getDuidType(), (Object)Dhcp6Duid.DuidType.DUID_LLT);
        Assert.assertEquals((long)clientIdOption.getDuid().getHardwareType(), (long)1L);
        Assert.assertEquals((long)clientIdOption.getDuid().getDuidTime(), (long)555636143L);
        Assert.assertArrayEquals((byte[])clientIdOption.getDuid().getLinkLayerAddress(), (byte[])CLIENT_MAC.toBytes());
        option = (Dhcp6Option)relaiedDhcp6.getOptions().get(2);
        Assert.assertEquals((long)option.getCode(), (long)DHCP6.OptionCode.SERVERID.value());
        Assert.assertEquals((long)option.getLength(), (long)14L);
        Dhcp6Duid serverDuid = (Dhcp6Duid)Dhcp6Duid.deserializer().deserialize(option.getData(), 0, option.getData().length);
        Assert.assertEquals((Object)serverDuid.getDuidType(), (Object)Dhcp6Duid.DuidType.DUID_LLT);
        Assert.assertEquals((long)serverDuid.getDuidTime(), (long)555635520L);
        Assert.assertEquals((long)serverDuid.getHardwareType(), (long)1L);
        Assert.assertArrayEquals((byte[])serverDuid.getLinkLayerAddress(), (byte[])SERVER_MAC.toBytes());
        Assert.assertArrayEquals((byte[])data, (byte[])eth.serialize());
    }

    @Test
    public void serializeReply() throws Exception {
        DHCP6 relayMsg = new DHCP6();
        relayMsg.setMsgType(DHCP6.MsgType.RELAY_REPL.value());
        relayMsg.setHopCount((byte)0);
        relayMsg.setLinkAddress(LINK_ADDRESS.toOctets());
        relayMsg.setPeerAddress(PEER_ADDRESS.toOctets());
        DHCP6 relaiedDhcp6 = new DHCP6();
        relaiedDhcp6.setMsgType(DHCP6.MsgType.REPLY.value());
        relaiedDhcp6.setTransactionId(14742082);
        ArrayList options = Lists.newArrayList();
        Dhcp6IaAddressOption iaAddressOption = new Dhcp6IaAddressOption();
        iaAddressOption.setIp6Address(IA_ADDRESS);
        iaAddressOption.setPreferredLifetime(375);
        iaAddressOption.setValidLifetime(600);
        Dhcp6IaNaOption iaNaOption = new Dhcp6IaNaOption();
        iaNaOption.setIaId(1);
        iaNaOption.setT1(0);
        iaNaOption.setT2(0);
        iaNaOption.setOptions((List)ImmutableList.of((Object)iaAddressOption));
        options.add(iaNaOption);
        Dhcp6Duid duid = new Dhcp6Duid();
        duid.setDuidType(Dhcp6Duid.DuidType.DUID_LLT);
        duid.setHardwareType((short)1);
        duid.setDuidTime(555636143);
        duid.setLinkLayerAddress(CLIENT_MAC.toBytes());
        Dhcp6ClientIdOption clientIdOption = new Dhcp6ClientIdOption();
        clientIdOption.setDuid(duid);
        options.add(clientIdOption);
        Dhcp6Option option = new Dhcp6Option();
        option.setCode(DHCP6.OptionCode.SERVERID.value());
        option.setLength((short)14);
        Dhcp6Duid serverDuid = new Dhcp6Duid();
        serverDuid.setDuidType(Dhcp6Duid.DuidType.DUID_LLT);
        serverDuid.setLinkLayerAddress(SERVER_MAC.toBytes());
        serverDuid.setHardwareType((short)1);
        serverDuid.setDuidTime(555635520);
        option.setData(serverDuid.serialize());
        options.add(option);
        relaiedDhcp6.setOptions((List)options);
        Dhcp6RelayOption relayOption = new Dhcp6RelayOption();
        relayOption.setPayload((IPacket)relaiedDhcp6);
        relayMsg.setOptions((List)ImmutableList.of((Object)relayOption));
        UDP udp = new UDP();
        udp.setSourcePort(547);
        udp.setDestinationPort(547);
        udp.setPayload((IPacket)relayMsg);
        udp.setChecksum((short)413);
        IPv6 ipv6 = new IPv6();
        ipv6.setHopLimit((byte)64);
        ipv6.setSourceAddress(SERVER_LL.toOctets());
        ipv6.setDestinationAddress(DOWNSTREAM_LL.toOctets());
        ipv6.setNextHeader((byte)17);
        ipv6.setTrafficClass((byte)0);
        ipv6.setFlowLabel(815855);
        ipv6.setPayload((IPacket)udp);
        Ethernet eth = new Ethernet();
        eth.setDestinationMACAddress(DOWNSTREAM_MAC);
        eth.setSourceMACAddress(SERVER_MAC);
        eth.setEtherType(Ethernet.TYPE_IPV6);
        eth.setPayload((IPacket)ipv6);
        Assert.assertArrayEquals((byte[])Resources.toByteArray((URL)Dhcp6RelayTest.class.getResource(REPLY)), (byte[])eth.serialize());
    }
}

