/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.TestTools;
import org.onlab.util.GroupedThreadFactory;

public class GroupedThreadFactoryTest {
    @Test
    public void basics() {
        GroupedThreadFactory a = GroupedThreadFactory.groupedThreadFactory((String)"foo");
        GroupedThreadFactory b = GroupedThreadFactory.groupedThreadFactory((String)"foo");
        Assert.assertSame((String)"factories should be same", (Object)a, (Object)b);
        Assert.assertTrue((String)"wrong toString", (boolean)a.toString().contains("foo"));
        Thread t = a.newThread(() -> TestTools.print((String)"yo"));
        Assert.assertSame((String)"wrong group", (Object)a.threadGroup(), (Object)t.getThreadGroup());
    }

    @Test
    public void hierarchical() {
        GroupedThreadFactory a = GroupedThreadFactory.groupedThreadFactory((String)"foo/bar");
        GroupedThreadFactory b = GroupedThreadFactory.groupedThreadFactory((String)"foo/goo");
        GroupedThreadFactory p = GroupedThreadFactory.groupedThreadFactory((String)"foo");
        Assert.assertSame((String)"groups should be same", (Object)p.threadGroup(), (Object)a.threadGroup().getParent());
        Assert.assertSame((String)"groups should be same", (Object)p.threadGroup(), (Object)b.threadGroup().getParent());
        Assert.assertEquals((String)"wrong name", (Object)"foo/bar", (Object)a.threadGroup().getName());
        Assert.assertEquals((String)"wrong name", (Object)"foo/goo", (Object)b.threadGroup().getName());
        Assert.assertEquals((String)"wrong name", (Object)"foo", (Object)p.threadGroup().getName());
    }
}

