/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeigher;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Heap;
import org.onlab.graph.Vertex;
import org.onlab.graph.Weight;

public class DijkstraGraphSearch<V extends Vertex, E extends Edge<V>>
extends AbstractGraphPathSearch<V, E> {
    @Override
    protected GraphPathSearch.Result<V, E> internalSearch(Graph<V, E> graph, V src, V dst, EdgeWeigher<V, E> weigher, int maxPaths) {
        Vertex nearest;
        AbstractGraphPathSearch.DefaultResult result = new AbstractGraphPathSearch.DefaultResult((AbstractGraphPathSearch)this, src, dst, maxPaths);
        result.updateVertex(src, null, weigher.getInitialWeight(), false);
        if (graph.getEdges().isEmpty()) {
            result.buildPaths();
            return result;
        }
        Heap<V> minQueue = this.createMinQueue(graph.getVertexes(), new PathCostComparator(result));
        while (!minQueue.isEmpty() && !(nearest = (Vertex)minQueue.extractExtreme()).equals(dst)) {
            if (result.hasCost(nearest)) {
                Weight cost = result.cost(nearest);
                for (Edge e : graph.getEdgesFrom(nearest)) {
                    result.relaxEdge(e, cost, weigher, true);
                }
            }
            minQueue.heapify();
        }
        result.buildPaths();
        return result;
    }

    private Heap<V> createMinQueue(Set<V> vertexes, Comparator<V> comparator) {
        return new Heap<V>(new ArrayList<V>(vertexes), comparator);
    }

    private final class PathCostComparator
    implements Comparator<V> {
        private final AbstractGraphPathSearch.DefaultResult result;

        private PathCostComparator(AbstractGraphPathSearch.DefaultResult result) {
            this.result = result;
        }

        @Override
        public int compare(V v1, V v2) {
            if (!this.result.hasCost(v1) && !this.result.hasCost(v2)) {
                return 0;
            }
            if (!this.result.hasCost(v1)) {
                return -1;
            }
            if (!this.result.hasCost(v2)) {
                return 1;
            }
            return this.result.cost(v2).compareTo(this.result.cost(v1));
        }
    }
}

