/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.DijkstraGraphSearch;
import org.onlab.graph.DisjointPathPair;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeigher;
import org.onlab.graph.GAOrganism;
import org.onlab.graph.GAPopulation;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Path;
import org.onlab.graph.SuurballeGraphSearch;
import org.onlab.graph.Vertex;
import org.onlab.graph.Weight;

public class SrlgGraphSearch<V extends Vertex, E extends Edge<V>>
extends AbstractGraphPathSearch<V, E> {
    static final int ITERATIONS = 100;
    static final int POPSIZE = 50;
    boolean useSuurballe = false;
    static final double INF = 1.0E8;
    int numGroups;
    Map<E, Integer> riskGrouping;
    Graph<V, E> orig;
    V src;
    V dst;
    EdgeWeigher<V, E> weigher;

    public SrlgGraphSearch(int groups, Map<E, Integer> grouping) {
        this.numGroups = groups;
        this.riskGrouping = grouping;
    }

    public SrlgGraphSearch(Map<E, Object> grouping) {
        if (grouping == null) {
            this.useSuurballe = true;
            return;
        }
        this.numGroups = 0;
        HashMap<Object, Integer> tmpMap = new HashMap<Object, Integer>();
        this.riskGrouping = new HashMap<E, Integer>();
        for (Edge key : grouping.keySet()) {
            Object value = grouping.get(key);
            if (!tmpMap.containsKey(value)) {
                tmpMap.put(value, this.numGroups);
                ++this.numGroups;
            }
            this.riskGrouping.put(key, (Integer)tmpMap.get(value));
        }
    }

    @Override
    protected GraphPathSearch.Result<V, E> internalSearch(Graph<V, E> graph, V src, V dst, EdgeWeigher<V, E> weigher, int maxPaths) {
        if (maxPaths == -1) {
            maxPaths = 50;
        }
        if (this.useSuurballe) {
            return new SuurballeGraphSearch<V, E>().search(graph, src, dst, weigher, -1);
        }
        this.orig = graph;
        this.src = src;
        this.dst = dst;
        this.weigher = weigher;
        List<Subset> best = new GAPopulation<Subset>().runGA(100, 50, maxPaths, new Subset(new boolean[this.numGroups]));
        HashSet<DisjointPathPair> dpps = new HashSet<DisjointPathPair>();
        for (Subset s : best) {
            dpps.addAll(s.buildPaths());
        }
        final GraphPathSearch.Result<V, E> firstDijkstra = new DijkstraGraphSearch<V, E>().search(this.orig, src, dst, weigher, 1);
        return new GraphPathSearch.Result<V, E>((Vertex)src, (Vertex)dst, dpps){
            final AbstractGraphPathSearch.DefaultResult search;
            final /* synthetic */ Vertex val$src;
            final /* synthetic */ Vertex val$dst;
            final /* synthetic */ Set val$dpps;
            {
                this.val$src = vertex;
                this.val$dst = vertex2;
                this.val$dpps = set;
                this.search = (AbstractGraphPathSearch.DefaultResult)firstDijkstra;
            }

            @Override
            public V src() {
                return this.val$src;
            }

            @Override
            public V dst() {
                return this.val$dst;
            }

            @Override
            public Set<Path<V, E>> paths() {
                HashSet pathsD = new HashSet();
                for (DisjointPathPair path : this.val$dpps) {
                    pathsD.add(path);
                }
                return pathsD;
            }

            @Override
            public Map<V, Weight> costs() {
                return this.search.costs();
            }

            @Override
            public Map<V, Set<E>> parents() {
                return this.search.parents();
            }
        };
    }

    private GraphPathSearch.Result<V, E> findShortestPathFromSubset(final boolean[] subset) {
        Graph<V, E> graph = this.orig;
        EdgeWeigher modified = new EdgeWeigher<V, E>(){
            final boolean[] subsetF;
            {
                this.subsetF = subset;
            }

            @Override
            public Weight weight(E edge) {
                if (this.subsetF[SrlgGraphSearch.this.riskGrouping.get(edge)]) {
                    return SrlgGraphSearch.this.weigher.weight(edge);
                }
                return SrlgGraphSearch.this.weigher.getNonViableWeight();
            }

            @Override
            public Weight getInitialWeight() {
                return SrlgGraphSearch.this.weigher.getInitialWeight();
            }

            @Override
            public Weight getNonViableWeight() {
                return SrlgGraphSearch.this.weigher.getNonViableWeight();
            }
        };
        GraphPathSearch.Result<V, E> res = new DijkstraGraphSearch<V, E>().search(graph, this.src, this.dst, modified, 1);
        return res;
    }

    class Subset
    implements GAOrganism {
        boolean[] subset;
        boolean[] not;
        Random r = new SecureRandom();

        public Subset(boolean[] sub) {
            this.subset = (boolean[])sub.clone();
            this.not = new boolean[this.subset.length];
            for (int i = 0; i < this.subset.length; ++i) {
                this.not[i] = !this.subset[i];
            }
        }

        @Override
        public Comparable fitness() {
            Set paths1 = SrlgGraphSearch.this.findShortestPathFromSubset(this.subset).paths();
            Set paths2 = SrlgGraphSearch.this.findShortestPathFromSubset(this.not).paths();
            if (paths1.isEmpty() || paths2.isEmpty()) {
                return SrlgGraphSearch.this.weigher.getNonViableWeight();
            }
            return paths1.iterator().next().cost().merge(paths2.iterator().next().cost());
        }

        @Override
        public void mutate() {
            for (int turns = this.r.nextInt((int)Math.sqrt(this.subset.length)); turns > 0; --turns) {
                int choose = this.r.nextInt(this.subset.length);
                this.subset[choose] = !this.subset[choose];
                this.not[choose] = !this.not[choose];
            }
        }

        @Override
        public GAOrganism crossWith(GAOrganism org) {
            if (!org.getClass().equals(this.getClass())) {
                return this;
            }
            Subset other = (Subset)org;
            boolean[] sub = new boolean[this.subset.length];
            for (int i = 0; i < this.subset.length; ++i) {
                sub[i] = this.subset[i];
                if (!this.r.nextBoolean()) continue;
                sub[i] = other.subset[i];
            }
            return new Subset(sub);
        }

        @Override
        public GAOrganism random() {
            boolean[] sub = new boolean[this.subset.length];
            for (int i = 0; i < sub.length; ++i) {
                sub[i] = this.r.nextBoolean();
            }
            return new Subset(sub);
        }

        public Set<DisjointPathPair> buildPaths() {
            HashSet<DisjointPathPair> dpps = new HashSet<DisjointPathPair>();
            for (Path path1 : SrlgGraphSearch.this.findShortestPathFromSubset(this.subset).paths()) {
                for (Path path2 : SrlgGraphSearch.this.findShortestPathFromSubset(this.not).paths()) {
                    DisjointPathPair dpp = new DisjointPathPair(path1, path2);
                    dpps.add(dpp);
                }
            }
            return dpps;
        }
    }
}

