/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeigher;
import org.onlab.graph.Graph;
import org.onlab.graph.Vertex;
import org.onlab.graph.Weight;

public class DepthFirstSearch<V extends Vertex, E extends Edge<V>>
extends AbstractGraphPathSearch<V, E> {
    protected SpanningTreeResult internalSearch(Graph<V, E> graph, V src, V dst, EdgeWeigher<V, E> weigher, int maxPaths) {
        Vertex vertex;
        SpanningTreeResult result = new SpanningTreeResult(this, src, dst, maxPaths);
        result.updateVertex(src, null, weigher.getInitialWeight(), true);
        HashSet<Vertex> finished = new HashSet<Vertex>();
        LinkedList stack = new LinkedList();
        stack.push(src);
        while (!stack.isEmpty() && !(vertex = (Vertex)stack.peek()).equals(dst)) {
            Weight cost = result.cost(vertex);
            boolean tangent = false;
            for (Edge edge : graph.getEdgesFrom(vertex)) {
                if (result.isEdgeMarked(edge)) continue;
                Object nextVertex = edge.dst();
                if (!result.hasCost(nextVertex)) {
                    result.markEdge(edge, EdgeType.TREE_EDGE);
                    Weight newCost = cost.merge(weigher.weight(edge));
                    result.updateVertex(nextVertex, edge, newCost, true);
                    stack.push(nextVertex);
                    tangent = true;
                    break;
                }
                if (!finished.contains(nextVertex)) {
                    result.markEdge(edge, EdgeType.BACK_EDGE);
                    continue;
                }
                result.markEdge(edge, this.isForwardEdge(result, edge) ? EdgeType.FORWARD_EDGE : EdgeType.CROSS_EDGE);
            }
            if (tangent) continue;
            finished.add(vertex);
            stack.pop();
        }
        result.buildPaths();
        return result;
    }

    protected boolean isForwardEdge(AbstractGraphPathSearch.DefaultResult result, E edge) {
        Set parentEdges;
        Object target = edge.src();
        Object vertex = edge.dst();
        while ((parentEdges = result.parents.get(vertex)) != null) {
            for (Edge parentEdge : parentEdges) {
                vertex = parentEdge.src();
                if (!vertex.equals(target)) continue;
                return true;
            }
        }
        return false;
    }

    public class SpanningTreeResult
    extends AbstractGraphPathSearch.DefaultResult {
        protected final Map<E, EdgeType> edges;
        final /* synthetic */ DepthFirstSearch this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public SpanningTreeResult(V src, V dst, int maxPaths) {
            this.this$0 = (DepthFirstSearch)this$0;
            super((AbstractGraphPathSearch)this$0, src, dst, maxPaths);
            this.edges = new HashMap();
        }

        public Map<E, EdgeType> edges() {
            return this.edges;
        }

        boolean isEdgeMarked(E edge) {
            return this.edges.containsKey(edge);
        }

        void markEdge(E edge, EdgeType type) {
            this.edges.put(edge, type);
        }
    }

    public static enum EdgeType {
        TREE_EDGE,
        FORWARD_EDGE,
        BACK_EDGE,
        CROSS_EDGE;

    }
}

