/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.EAPOLMkpduParameterSet;

public class EAPOLMkpduPeerListParameterSet
extends BasePacket
implements EAPOLMkpduParameterSet {
    public static byte peerListTypeLive = 1;
    public static byte peerListTypePotential = (byte)2;
    protected byte peerListType = 1;
    protected short bodyLength;
    protected List<MemberDetails> members = new ArrayList<MemberDetails>();

    @Override
    public byte[] serialize() {
        if (this.members.size() == 0) {
            return null;
        }
        short length = this.getTotalLength();
        ByteBuffer data = ByteBuffer.wrap(new byte[length]);
        data.put(this.peerListType);
        byte octet = 0;
        data.put(octet);
        length = (short)(length - 4);
        octet = (byte)(octet | (byte)(length >> 8 & 0xF));
        data.put(octet);
        data.put((byte)length);
        this.members.forEach(a -> {
            data.put(a.getMemberID());
            data.putInt(a.getMessageNo());
        });
        return data.array();
    }

    public static Deserializer<EAPOLMkpduPeerListParameterSet> deserializer() {
        return (data, offset, length) -> {
            if (data == null) {
                return null;
            }
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            EAPOLMkpduPeerListParameterSet peerListParameterSet = new EAPOLMkpduPeerListParameterSet();
            byte[] mbField = new byte[1];
            bb.get();
            mbField[0] = bb.get();
            short bodyLength = (short)((short)(mbField[0] & 0xF) << 4);
            peerListParameterSet.setBodyLength(bodyLength);
            for (bodyLength = (short)(bodyLength | (short)bb.get()); bodyLength > 0; bodyLength = (short)(bodyLength - 16)) {
                mbField = new byte[12];
                bb.get(mbField, 0, 12);
                peerListParameterSet.addMember(mbField, bb.getInt());
            }
            return peerListParameterSet;
        };
    }

    public void setPeerListType(byte peerListType) {
        if (peerListType != peerListTypeLive && peerListType != peerListTypePotential) {
            throw new IllegalArgumentException("Unknown PeerList Type specified.");
        }
        this.peerListType = peerListType;
    }

    public void addMember(byte[] mi, int mn) {
        if (mi != null) {
            this.members.add(new MemberDetails(mi, mn));
        }
    }

    public boolean memberExists(byte[] mi) {
        MemberDetails member = this.members.stream().filter(m -> Arrays.equals(m.getMemberID(), mi)).findAny().orElse(null);
        return member != null;
    }

    public List<MemberDetails> getMembers() {
        return this.members;
    }

    @Override
    public byte getParameterSetType() {
        return this.peerListType;
    }

    @Override
    public short getTotalLength() {
        return (short)(4 + this.members.size() * 16);
    }

    @Override
    public short getBodyLength() {
        return this.bodyLength;
    }

    public void setBodyLength(short length) {
        this.bodyLength = length;
    }

    public static class MemberDetails {
        byte[] memberID;
        int messageNo;

        public MemberDetails(byte[] memberID, int messageNo) {
            this.memberID = memberID;
            this.messageNo = messageNo;
        }

        public byte[] getMemberID() {
            return this.memberID;
        }

        public int getMessageNo() {
            return this.messageNo;
        }
    }
}

