/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;

public class Dhcp6Option
extends BasePacket {
    public static final int DEFAULT_LEN = 4;
    protected static final int UNSIGNED_SHORT_MASK = 65535;
    private short code;
    private short length;

    public Dhcp6Option() {
    }

    public Dhcp6Option(Dhcp6Option dhcp6Option) {
        this.code = dhcp6Option.code;
        this.length = dhcp6Option.length;
        this.payload = dhcp6Option.payload;
        this.payload.setParent(this);
    }

    public void setCode(short code) {
        this.code = code;
    }

    public void setData(byte[] data) {
        try {
            this.payload = Data.deserializer().deserialize(data, 0, data.length);
        }
        catch (DeserializationException e) {
            throw new IllegalArgumentException("Invalid data");
        }
    }

    public void setLength(short length) {
        this.length = length;
    }

    public short getCode() {
        return this.code;
    }

    public short getLength() {
        return this.length;
    }

    public byte[] getData() {
        return this.payload.serialize();
    }

    public static Deserializer<Dhcp6Option> deserializer() {
        return (data, offset, len) -> {
            Dhcp6Option dhcp6Option = new Dhcp6Option();
            if (len < 4) {
                throw new DeserializationException("DHCPv6 option code lengthshould be at least 4 bytes");
            }
            ByteBuffer bb = ByteBuffer.wrap(data, offset, len);
            dhcp6Option.code = bb.getShort();
            dhcp6Option.length = bb.getShort();
            int optionLen = 0xFFFF & dhcp6Option.length;
            byte[] optData = new byte[optionLen];
            bb.get(optData);
            dhcp6Option.setData(optData);
            return dhcp6Option;
        };
    }

    @Override
    public byte[] serialize() {
        ByteBuffer bb = ByteBuffer.allocate(4 + this.getLength());
        bb.putShort(this.getCode());
        bb.putShort(this.getLength());
        bb.put(this.payload.serialize());
        return bb.array();
    }

    protected MoreObjects.ToStringHelper getToStringHelper() {
        return MoreObjects.toStringHelper(Dhcp6Option.class).add("code", (int)this.code).add("length", (int)this.length);
    }

    public String toString() {
        return this.getToStringHelper().add("data", (Object)this.payload.toString()).toString();
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.code, this.length);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Dhcp6Option other = (Dhcp6Option)obj;
        return Objects.equals(this.code, other.code) && Objects.equals(this.length, other.length);
    }
}

