/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.BellmanFordGraphSearch;
import org.onlab.graph.BreadthFirstSearchTest;
import org.onlab.graph.Path;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Vertex;

public class BellmanFordGraphSearchTest
extends BreadthFirstSearchTest {
    @Override
    protected AbstractGraphPathSearch<TestVertex, TestEdge> graphSearch() {
        return new BellmanFordGraphSearch();
    }

    @Override
    @Test
    public void defaultGraphTest() {
        this.executeDefaultTest(7, 5, 5.0);
    }

    @Override
    @Test
    public void defaultHopCountWeight() {
        this.weight = null;
        this.executeDefaultTest(10, 3, 3.0);
    }

    @Test
    public void searchGraphWithNegativeCycles() {
        HashSet<TestVertex> vertexes = new HashSet<TestVertex>(this.vertexes());
        vertexes.add(Z);
        HashSet<TestEdge> edges = new HashSet<TestEdge>(this.edges());
        edges.add(new TestEdge(G, Z, 1.0));
        edges.add(new TestEdge(Z, G, -2.0));
        this.graph = new AdjacencyListsGraph(vertexes, edges);
        AbstractGraphPathSearch<TestVertex, TestEdge> search = this.graphSearch();
        Set paths = search.search(this.graph, (Vertex)A, (Vertex)H, this.weight, -1).paths();
        Assert.assertEquals((String)"incorrect paths count", (long)1L, (long)paths.size());
        Path p = (Path)paths.iterator().next();
        Assert.assertEquals((String)"incorrect src", (Object)A, (Object)p.src());
        Assert.assertEquals((String)"incorrect dst", (Object)H, (Object)p.dst());
        Assert.assertEquals((String)"incorrect path length", (long)5L, (long)p.edges().size());
        Assert.assertEquals((String)"incorrect path cost", (double)5.0, (double)p.cost(), (double)0.1);
        paths = search.search(this.graph, (Vertex)A, (Vertex)G, this.weight, -1).paths();
        Assert.assertEquals((String)"incorrect paths count", (long)0L, (long)paths.size());
        paths = search.search(this.graph, (Vertex)A, null, this.weight, -1).paths();
        this.printPaths(paths);
        Assert.assertEquals((String)"incorrect paths count", (long)6L, (long)paths.size());
    }
}

