/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Vertex;

public class BellmanFordGraphSearch<V extends Vertex, E extends Edge<V>>
extends AbstractGraphPathSearch<V, E> {
    @Override
    public GraphPathSearch.Result<V, E> search(Graph<V, E> graph, V src, V dst, EdgeWeight<V, E> weight, int maxPaths) {
        this.checkArguments(graph, src, dst);
        AbstractGraphPathSearch.DefaultResult result = new AbstractGraphPathSearch.DefaultResult((AbstractGraphPathSearch)this, src, dst, maxPaths);
        result.updateVertex(src, null, 0.0, true);
        int max = graph.getVertexes().size() - 1;
        for (int i = 0; i < max; ++i) {
            for (Edge edge : graph.getEdges()) {
                if (!result.hasCost(edge.src())) continue;
                result.relaxEdge(edge, result.cost(edge.src()), weight, new boolean[0]);
            }
        }
        for (Edge edge : graph.getEdges()) {
            if (!result.hasCost(edge.src()) || !result.relaxEdge(edge, result.cost(edge.src()), weight, new boolean[0])) continue;
            result.removeVertex(edge.dst());
        }
        result.buildPaths();
        return result;
    }
}

