/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.util.Objects;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.Ip6Prefix;
import org.onlab.packet.IpAddress;

public class IpPrefix {
    public static final int MAX_INET_MASK_LENGTH = 32;
    public static final int MAX_INET6_MASK_LENGTH = 128;
    private final IpAddress address;
    private final short prefixLength;

    protected IpPrefix(IpAddress address, int prefixLength) {
        IpPrefix.checkPrefixLength(address.version(), prefixLength);
        this.address = IpAddress.makeMaskedAddress(address, prefixLength);
        this.prefixLength = (short)prefixLength;
    }

    public IpAddress.Version version() {
        return this.address.version();
    }

    public boolean isIp4() {
        return this.address.isIp4();
    }

    public boolean isIp6() {
        return this.address.isIp6();
    }

    public IpAddress address() {
        return this.address;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public Ip4Prefix getIp4Prefix() {
        if (!this.isIp4()) {
            return null;
        }
        if (this instanceof Ip4Prefix) {
            return (Ip4Prefix)this;
        }
        return Ip4Prefix.valueOf(this.address.getIp4Address(), (int)this.prefixLength);
    }

    public Ip6Prefix getIp6Prefix() {
        if (!this.isIp6()) {
            return null;
        }
        if (this instanceof Ip6Prefix) {
            return (Ip6Prefix)this;
        }
        return Ip6Prefix.valueOf(this.address.getIp6Address(), (int)this.prefixLength);
    }

    public static IpPrefix valueOf(int address, int prefixLength) {
        return new IpPrefix(IpAddress.valueOf(address), prefixLength);
    }

    public static IpPrefix valueOf(IpAddress.Version version, byte[] address, int prefixLength) {
        return new IpPrefix(IpAddress.valueOf(version, address), prefixLength);
    }

    public static IpPrefix valueOf(IpAddress address, int prefixLength) {
        return new IpPrefix(address, prefixLength);
    }

    public static IpPrefix valueOf(String address) {
        String[] parts = address.split("/");
        if (parts.length != 2) {
            String msg = "Malformed IP prefix string: " + address + ". " + "Address must take form \"x.x.x.x/y\" or " + "\"xxxx:xxxx:xxxx:xxxx:xxxx:xxxx:xxxx:xxxx/y\"";
            throw new IllegalArgumentException(msg);
        }
        IpAddress ipAddress = IpAddress.valueOf(parts[0]);
        int prefixLength = Integer.parseInt(parts[1]);
        return new IpPrefix(ipAddress, prefixLength);
    }

    public boolean contains(IpPrefix other) {
        if (this.version() != other.version()) {
            return false;
        }
        if (this.prefixLength > other.prefixLength) {
            return false;
        }
        IpAddress maskedAddr = IpAddress.makeMaskedAddress(other.address, this.prefixLength);
        return this.address.equals(maskedAddr);
    }

    public boolean contains(IpAddress other) {
        if (this.version() != other.version()) {
            return false;
        }
        IpAddress maskedAddr = IpAddress.makeMaskedAddress(other, this.prefixLength);
        return this.address.equals(maskedAddr);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.prefixLength);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof IpPrefix)) {
            return false;
        }
        IpPrefix other = (IpPrefix)obj;
        return this.prefixLength == other.prefixLength && this.address.equals(other.address);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.address.toString());
        builder.append("/");
        builder.append(String.format("%d", this.prefixLength));
        return builder.toString();
    }

    private static void checkPrefixLength(IpAddress.Version version, int prefixLength) {
        int maxPrefixLen = 0;
        switch (version) {
            case INET: {
                maxPrefixLen = 32;
                break;
            }
            case INET6: {
                maxPrefixLen = 128;
                break;
            }
            default: {
                String msg = "Invalid IP version " + (Object)((Object)version);
                throw new IllegalArgumentException(msg);
            }
        }
        if (prefixLength < 0 || prefixLength > maxPrefixLen) {
            String msg = "Invalid prefix length " + prefixLength + ". " + "The value must be in the interval [0, " + maxPrefixLen + "]";
            throw new IllegalArgumentException(msg);
        }
    }
}

