/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.Frequency;

public class FrequencyTest {
    private final Frequency frequency1 = Frequency.ofMHz((double)1000.0);
    private final Frequency sameFrequency1 = Frequency.ofMHz((double)1000.0);
    private final Frequency frequency2 = Frequency.ofGHz((double)1000.0);
    private final Frequency sameFrequency2 = Frequency.ofGHz((double)1000.0);
    private final Frequency moreSameFrequency2 = Frequency.ofTHz((double)1.0);
    private final Frequency frequency3 = Frequency.ofTHz((double)193.1);
    private final Frequency sameFrequency3 = Frequency.ofGHz((double)193100.0);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(Frequency.class);
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.frequency1, this.sameFrequency1}).addEqualityGroup(new Object[]{this.frequency2, this.sameFrequency2, this.moreSameFrequency2}).addEqualityGroup(new Object[]{this.frequency3, this.sameFrequency3}).testEquals();
    }

    @Test
    public void testLessThan() {
        MatcherAssert.assertThat((Object)this.frequency1, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)this.frequency2)));
        MatcherAssert.assertThat((Object)this.frequency1.isLessThan((Object)this.frequency2), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGreaterThan() {
        MatcherAssert.assertThat((Object)this.frequency2, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)this.frequency1)));
        MatcherAssert.assertThat((Object)this.frequency2.isGreaterThan((Object)this.frequency1), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAdd() {
        Frequency low = Frequency.ofMHz((double)100.0);
        Frequency high = Frequency.ofGHz((double)1.0);
        Frequency expected = Frequency.ofMHz((double)1100.0);
        MatcherAssert.assertThat((Object)low.add(high), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testSubtract() {
        Frequency high = Frequency.ofGHz((double)1.0);
        Frequency low = Frequency.ofMHz((double)100.0);
        Frequency expected = Frequency.ofMHz((double)900.0);
        MatcherAssert.assertThat((Object)high.subtract(low), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testMultiply() {
        Frequency frequency = Frequency.ofMHz((double)1000.0);
        long factor = 5L;
        Frequency expected = Frequency.ofGHz((double)5.0);
        MatcherAssert.assertThat((Object)frequency.multiply(5L), (Matcher)Matchers.is((Object)expected));
    }
}

