/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.onlab.packet.BasePacket;
import org.onlab.packet.IPacket;
import org.onlab.packet.LLDPOrganizationalTLV;
import org.onlab.packet.LLDPTLV;

public class LLDP
extends BasePacket {
    protected LLDPTLV chassisId;
    protected LLDPTLV portId;
    protected LLDPTLV ttl;
    protected List<LLDPTLV> optionalTLVList = new ArrayList<LLDPTLV>();
    protected short ethType = (short)-30516;

    public LLDPTLV getChassisId() {
        return this.chassisId;
    }

    public LLDP setChassisId(LLDPTLV chassis) {
        this.chassisId = chassis;
        return this;
    }

    public LLDPTLV getPortId() {
        return this.portId;
    }

    public LLDP setPortId(LLDPTLV portId) {
        this.portId = portId;
        return this;
    }

    public LLDPTLV getTtl() {
        return this.ttl;
    }

    public LLDP setTtl(LLDPTLV ttl) {
        this.ttl = ttl;
        return this;
    }

    public List<LLDPTLV> getOptionalTLVList() {
        return this.optionalTLVList;
    }

    public LLDP setOptionalTLVList(List<LLDPTLV> optionalTLVList) {
        this.optionalTLVList = optionalTLVList;
        return this;
    }

    @Override
    public byte[] serialize() {
        int length = 2 + this.chassisId.getLength() + 2 + this.portId.getLength() + 2 + this.ttl.getLength() + 2;
        for (LLDPTLV tlv : this.optionalTLVList) {
            length += 2 + tlv.getLength();
        }
        byte[] data = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.chassisId.serialize());
        bb.put(this.portId.serialize());
        bb.put(this.ttl.serialize());
        for (LLDPTLV tlv : this.optionalTLVList) {
            bb.put(tlv.serialize());
        }
        bb.putShort((short)0);
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        LLDPTLV tlv;
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        while ((tlv = new LLDPOrganizationalTLV().deserialize(bb)) != null) {
            switch (tlv.getType()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.chassisId = tlv;
                    break;
                }
                case 2: {
                    this.portId = tlv;
                    break;
                }
                case 3: {
                    this.ttl = tlv;
                    break;
                }
                default: {
                    this.optionalTLVList.add(tlv);
                }
            }
            if (tlv.getType() != 0 && bb.hasRemaining()) continue;
        }
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 883;
        int result = super.hashCode();
        result = 883 * result + (this.chassisId == null ? 0 : this.chassisId.hashCode());
        result = 883 * result + this.optionalTLVList.hashCode();
        result = 883 * result + (this.portId == null ? 0 : this.portId.hashCode());
        result = 883 * result + (this.ttl == null ? 0 : this.ttl.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LLDP)) {
            return false;
        }
        LLDP other = (LLDP)obj;
        if (this.chassisId == null ? other.chassisId != null : !this.chassisId.equals(other.chassisId)) {
            return false;
        }
        if (!this.optionalTLVList.equals(other.optionalTLVList)) {
            return false;
        }
        if (this.portId == null ? other.portId != null : !this.portId.equals(other.portId)) {
            return false;
        }
        return !(this.ttl == null ? other.ttl != null : !this.ttl.equals(other.ttl));
    }
}

