/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DHCP;
import org.onlab.packet.Data;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;

public class UDP
extends BasePacket {
    public static final Map<Short, Class<? extends IPacket>> DECODE_MAP = new HashMap<Short, Class<? extends IPacket>>();
    public static final short DHCP_SERVER_PORT = 67;
    public static final short DHCP_CLIENT_PORT = 68;
    protected short sourcePort;
    protected short destinationPort;
    protected short length;
    protected short checksum;

    public short getSourcePort() {
        return this.sourcePort;
    }

    public UDP setSourcePort(short sourcePort) {
        this.sourcePort = sourcePort;
        return this;
    }

    public short getDestinationPort() {
        return this.destinationPort;
    }

    public UDP setDestinationPort(short destinationPort) {
        this.destinationPort = destinationPort;
        return this;
    }

    public short getLength() {
        return this.length;
    }

    public short getChecksum() {
        return this.checksum;
    }

    public UDP setChecksum(short checksum) {
        this.checksum = checksum;
        return this;
    }

    @Override
    public void resetChecksum() {
        this.checksum = 0;
        super.resetChecksum();
    }

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        this.length = (short)(8 + (payloadData == null ? 0 : payloadData.length));
        byte[] data = new byte[this.length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putShort(this.sourcePort);
        bb.putShort(this.destinationPort);
        bb.putShort(this.length);
        bb.putShort(this.checksum);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        if (this.parent != null && this.parent instanceof IPv4) {
            ((IPv4)this.parent).setProtocol((byte)17);
        }
        if (this.checksum == 0) {
            bb.rewind();
            int accumulation = 0;
            if (this.parent != null) {
                if (this.parent instanceof IPv4) {
                    IPv4 ipv4 = (IPv4)this.parent;
                    accumulation += (ipv4.getSourceAddress() >> 16 & 0xFFFF) + (ipv4.getSourceAddress() & 0xFFFF);
                    accumulation += (ipv4.getDestinationAddress() >> 16 & 0xFFFF) + (ipv4.getDestinationAddress() & 0xFFFF);
                    accumulation += ipv4.getProtocol() & 0xFF;
                    accumulation += this.length & 0xFFFF;
                } else if (this.parent instanceof IPv6) {
                    IPv6 ipv6 = (IPv6)this.parent;
                    int bbLength = 38;
                    ByteBuffer bbChecksum = ByteBuffer.allocate(38);
                    bbChecksum.put(ipv6.getSourceAddress());
                    bbChecksum.put(ipv6.getDestinationAddress());
                    bbChecksum.put((byte)0);
                    bbChecksum.put(ipv6.getNextHeader());
                    bbChecksum.putInt(this.length);
                    bbChecksum.rewind();
                    for (int i = 0; i < 19; ++i) {
                        accumulation += 0xFFFF & bbChecksum.getShort();
                    }
                }
            }
            for (int i = 0; i < this.length / 2; ++i) {
                accumulation += 0xFFFF & bb.getShort();
            }
            if (this.length % 2 > 0) {
                accumulation += (bb.get() & 0xFF) << 8;
            }
            accumulation = (accumulation >> 16 & 0xFFFF) + (accumulation & 0xFFFF);
            this.checksum = (short)(~accumulation & 0xFFFF);
            bb.putShort(6, this.checksum);
        }
        return data;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.checksum;
        result = 5807 * result + this.destinationPort;
        result = 5807 * result + this.length;
        result = 5807 * result + this.sourcePort;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof UDP)) {
            return false;
        }
        UDP other = (UDP)obj;
        if (this.checksum != other.checksum) {
            return false;
        }
        if (this.destinationPort != other.destinationPort) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        return this.sourcePort == other.sourcePort;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        this.sourcePort = bb.getShort();
        this.destinationPort = bb.getShort();
        this.length = bb.getShort();
        this.checksum = bb.getShort();
        if (DECODE_MAP.containsKey(this.destinationPort)) {
            try {
                this.payload = DECODE_MAP.get(this.destinationPort).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failure instantiating class", e);
            }
        } else if (DECODE_MAP.containsKey(this.sourcePort)) {
            try {
                this.payload = DECODE_MAP.get(this.sourcePort).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failure instantiating class", e);
            }
        } else {
            this.payload = new Data();
        }
        this.payload = this.payload.deserialize(data, bb.position(), bb.limit() - bb.position());
        this.payload.setParent(this);
        return this;
    }

    static {
        DECODE_MAP.put((short)67, DHCP.class);
        DECODE_MAP.put((short)68, DHCP.class);
    }
}

