/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ipv6;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv6;
import org.onlab.packet.ipv6.IExtensionHeader;

public class BaseOptions
extends BasePacket
implements IExtensionHeader {
    public static final byte FIXED_HEADER_LENGTH = 2;
    public static final byte FIXED_OPTIONS_LENGTH = 6;
    public static final byte LENGTH_UNIT = 8;
    protected byte nextHeader;
    protected byte headerExtLength;
    protected byte[] options;
    protected byte type;

    @Override
    public byte getNextHeader() {
        return this.nextHeader;
    }

    @Override
    public BaseOptions setNextHeader(byte nextHeader) {
        this.nextHeader = nextHeader;
        return this;
    }

    public byte getHeaderExtLength() {
        return this.headerExtLength;
    }

    public BaseOptions setHeaderExtLength(byte headerExtLength) {
        this.headerExtLength = headerExtLength;
        return this;
    }

    public byte[] getOptions() {
        return this.options;
    }

    public BaseOptions setOptions(byte[] options) {
        this.options = Arrays.copyOfRange(options, 0, options.length);
        return this;
    }

    protected byte getType() {
        return this.type;
    }

    protected BaseOptions setType(byte type) {
        this.type = type;
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        int headerLength = 2 + this.options.length;
        int payloadLength = 0;
        if (payloadData != null) {
            payloadLength = payloadData.length;
        }
        byte[] data = new byte[headerLength + payloadLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.nextHeader);
        bb.put(this.headerExtLength);
        bb.put(this.options, 0, this.options.length);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        if (this.parent != null && this.parent instanceof IExtensionHeader) {
            ((IExtensionHeader)((Object)this.parent)).setNextHeader(this.type);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        IPacket payload;
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        this.nextHeader = bb.get();
        this.headerExtLength = bb.get();
        int optionLength = 6 + 8 * this.headerExtLength;
        this.options = new byte[optionLength];
        bb.get(this.options, 0, optionLength);
        if (IPv6.PROTOCOL_CLASS_MAP.containsKey(this.nextHeader)) {
            Class<? extends IPacket> clazz = IPv6.PROTOCOL_CLASS_MAP.get(this.nextHeader);
            try {
                payload = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing payload for BaseOptions packet", e);
            }
        } else {
            payload = new Data();
        }
        this.payload = payload.deserialize(data, bb.position(), bb.limit() - bb.position());
        this.payload.setParent(this);
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.nextHeader;
        result = 5807 * result + this.headerExtLength;
        for (byte b : this.options) {
            result = 5807 * result + b;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BaseOptions)) {
            return false;
        }
        BaseOptions other = (BaseOptions)obj;
        if (this.nextHeader != other.nextHeader) {
            return false;
        }
        if (this.headerExtLength != other.headerExtLength) {
            return false;
        }
        if (!Arrays.equals(this.options, other.options)) {
            return false;
        }
        return this.type == other.type;
    }
}

