/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ndp;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.onlab.packet.BasePacket;
import org.onlab.packet.IPacket;
import org.onlab.packet.ndp.NeighborDiscoveryOptions;

public class NeighborAdvertisement
extends BasePacket {
    public static final byte HEADER_LENGTH = 20;
    protected byte routerFlag;
    protected byte solicitedFlag;
    protected byte overrideFlag;
    protected byte[] targetAddress = new byte[16];
    private final NeighborDiscoveryOptions options = new NeighborDiscoveryOptions();

    public byte getRouterFlag() {
        return this.routerFlag;
    }

    public NeighborAdvertisement setRouterFlag(byte routerFlag) {
        this.routerFlag = routerFlag;
        return this;
    }

    public byte getSolicitedFlag() {
        return this.solicitedFlag;
    }

    public NeighborAdvertisement setSolicitedFlag(byte solicitedFlag) {
        this.solicitedFlag = solicitedFlag;
        return this;
    }

    public byte getOverrideFlag() {
        return this.overrideFlag;
    }

    public NeighborAdvertisement setOverrideFlag(byte overrideFlag) {
        this.overrideFlag = overrideFlag;
        return this;
    }

    public byte[] getTargetAddress() {
        return this.targetAddress;
    }

    public NeighborAdvertisement setTargetAddress(byte[] targetAddress) {
        this.targetAddress = Arrays.copyOfRange(targetAddress, 0, 16);
        return this;
    }

    public List<NeighborDiscoveryOptions.Option> getOptions() {
        return this.options.options();
    }

    public NeighborAdvertisement addOption(byte type, byte[] data) {
        this.options.addOption(type, data);
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] optionsData = null;
        if (this.options.hasOptions()) {
            optionsData = this.options.serialize();
        }
        int optionsLength = 0;
        if (optionsData != null) {
            optionsLength = optionsData.length;
        }
        byte[] data = new byte[20 + optionsLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putInt((this.routerFlag & 1) << 31 | (this.solicitedFlag & 1) << 30 | (this.overrideFlag & 1) << 29);
        bb.put(this.targetAddress, 0, 16);
        if (optionsData != null) {
            bb.put(optionsData);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        int iscratch = bb.getInt();
        this.routerFlag = (byte)(iscratch >> 31 & 1);
        this.solicitedFlag = (byte)(iscratch >> 30 & 1);
        this.overrideFlag = (byte)(iscratch >> 29 & 1);
        bb.get(this.targetAddress, 0, 16);
        this.options.deserialize(data, bb.position(), bb.limit() - bb.position());
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.routerFlag;
        result = 5807 * result + this.solicitedFlag;
        result = 5807 * result + this.overrideFlag;
        ByteBuffer bb = ByteBuffer.wrap(this.targetAddress);
        for (int i = 0; i < this.targetAddress.length / 4; ++i) {
            result = 5807 * result + bb.getInt();
        }
        result = 5807 * result + this.options.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof NeighborAdvertisement)) {
            return false;
        }
        NeighborAdvertisement other = (NeighborAdvertisement)obj;
        if (this.routerFlag != other.routerFlag) {
            return false;
        }
        if (this.solicitedFlag != other.solicitedFlag) {
            return false;
        }
        if (this.overrideFlag != other.overrideFlag) {
            return false;
        }
        if (!Arrays.equals(this.targetAddress, other.targetAddress)) {
            return false;
        }
        return this.options.equals(other.options);
    }
}

