/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Strings;
import com.google.common.primitives.UnsignedLongs;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.onlab.util.GroupedThreadFactory;
import org.onlab.util.ItemNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Tools {
    private static final Logger log = LoggerFactory.getLogger(Tools.class);
    private static Random random = new Random();

    private Tools() {
    }

    public static ThreadFactory namedThreads(String pattern) {
        return new ThreadFactoryBuilder().setNameFormat(pattern).setUncaughtExceptionHandler((t, e) -> log.error("Uncaught exception on " + t.getName(), e)).build();
    }

    public static ThreadFactory groupedThreads(String groupName, String pattern) {
        return new ThreadFactoryBuilder().setThreadFactory((ThreadFactory)GroupedThreadFactory.groupedThreadFactory(groupName)).setNameFormat(groupName.replace("/", "-") + "-" + pattern).setUncaughtExceptionHandler((t, e) -> log.error("Uncaught exception on " + t.getName(), e)).build();
    }

    public static ThreadFactory minPriority(ThreadFactory factory) {
        return new ThreadFactoryBuilder().setThreadFactory(factory).setPriority(1).build();
    }

    public static boolean isNullOrEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> T nullIsNotFound(T item, String message) {
        if (item == null) {
            throw new ItemNotFoundException(message);
        }
        return item;
    }

    public static long fromHex(String string) {
        return UnsignedLongs.parseUnsignedLong((String)string, (int)16);
    }

    public static String toHex(long value) {
        return Strings.padStart((String)UnsignedLongs.toString((long)value, (int)16), (int)16, (char)'0');
    }

    public static String toHex(long value, int width) {
        return Strings.padStart((String)UnsignedLongs.toString((long)value, (int)16), (int)width, (char)'0');
    }

    public static String get(Dictionary<?, ?> properties, String propertyName) {
        Object v = properties.get(propertyName);
        String s = v instanceof String ? (String)v : (v != null ? v.toString() : null);
        return Strings.isNullOrEmpty((String)s) ? null : s.trim();
    }

    public static void delay(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
    }

    public static void randomDelay(int ms) {
        try {
            Thread.sleep(random.nextInt(ms));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
    }

    public static void delay(int ms, int nanos) {
        try {
            Thread.sleep(ms, nanos);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
    }

    public static List<String> slurp(File path) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void removeDirectory(String path) throws IOException {
        DirectoryDeleter visitor = new DirectoryDeleter();
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            Files.walkFileTree(Paths.get(path, new String[0]), visitor);
            if (visitor.exception != null) {
                throw visitor.exception;
            }
        }
    }

    public static void removeDirectory(File dir) throws IOException {
        DirectoryDeleter visitor = new DirectoryDeleter();
        if (dir.exists() && dir.isDirectory()) {
            Files.walkFileTree(Paths.get(dir.getAbsolutePath(), new String[0]), visitor);
            if (visitor.exception != null) {
                throw visitor.exception;
            }
        }
    }

    public static String timeAgo(long unixTime) {
        long deltaMillis = System.currentTimeMillis() - unixTime;
        long secondsSince = (long)((double)deltaMillis / 1000.0);
        long minsSince = (long)((double)deltaMillis / 60000.0);
        long hoursSince = (long)((double)deltaMillis / 3600000.0);
        long daysSince = (long)((double)deltaMillis / 8.64E7);
        if (daysSince > 0L) {
            return String.format("%dd ago", daysSince);
        }
        if (hoursSince > 0L) {
            return String.format("%dh ago", hoursSince);
        }
        if (minsSince > 0L) {
            return String.format("%dm ago", minsSince);
        }
        if (secondsSince > 0L) {
            return String.format("%ds ago", secondsSince);
        }
        return "just now";
    }

    public static void copyDirectory(String src, String dst) throws IOException {
        Files.walkFileTree(Paths.get(src, new String[0]), new DirectoryCopier(src, dst));
    }

    public static void copyDirectory(File src, File dst) throws IOException {
        Files.walkFileTree(Paths.get(src.getAbsolutePath(), new String[0]), new DirectoryCopier(src.getAbsolutePath(), dst.getAbsolutePath()));
    }

    public static <T> T futureGetOrElse(Future<T> future, T defaultValue) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return defaultValue;
        }
        catch (ExecutionException e) {
            return defaultValue;
        }
    }

    public static <T> T futureGetOrElse(Future<T> future, long timeout, TimeUnit timeUnit, T defaultValue) {
        try {
            return future.get(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return defaultValue;
        }
        catch (ExecutionException | TimeoutException e) {
            return defaultValue;
        }
    }

    public static <T> CompletableFuture<T> exceptionalFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public static byte[] byteBuffertoArray(ByteBuffer buffer) {
        int length = buffer.remaining();
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            return Arrays.copyOfRange(buffer.array(), offset, offset + length);
        }
        byte[] bytes = new byte[length];
        buffer.duplicate().get(bytes);
        return bytes;
    }

    private static class DirectoryCopier
    extends SimpleFileVisitor<Path> {
        private Path src;
        private Path dst;
        private StandardCopyOption copyOption = StandardCopyOption.REPLACE_EXISTING;

        DirectoryCopier(String src, String dst) {
            this.src = Paths.get(src, new String[0]);
            this.dst = Paths.get(dst, new String[0]);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.dst.resolve(this.src.relativize(dir));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.dst.resolve(this.src.relativize(file)), this.copyOption);
            return FileVisitResult.CONTINUE;
        }
    }

    private static class DirectoryDeleter
    extends SimpleFileVisitor<Path> {
        private IOException exception;

        private DirectoryDeleter() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            if (attributes.isRegularFile()) {
                Files.delete(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path directory, IOException ioe) throws IOException {
            Files.delete(directory);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException ioe) throws IOException {
            this.exception = ioe;
            return FileVisitResult.TERMINATE;
        }
    }
}

