/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;

public class TCP
extends BasePacket {
    protected short sourcePort;
    protected short destinationPort;
    protected int sequence;
    protected int acknowledge;
    protected byte dataOffset;
    protected short flags;
    protected short windowSize;
    protected short checksum;
    protected short urgentPointer;
    protected byte[] options;

    public short getSourcePort() {
        return this.sourcePort;
    }

    public TCP setSourcePort(short sourcePort) {
        this.sourcePort = sourcePort;
        return this;
    }

    public short getDestinationPort() {
        return this.destinationPort;
    }

    public TCP setDestinationPort(short destinationPort) {
        this.destinationPort = destinationPort;
        return this;
    }

    public short getChecksum() {
        return this.checksum;
    }

    public TCP setChecksum(short checksum) {
        this.checksum = checksum;
        return this;
    }

    public int getSequence() {
        return this.sequence;
    }

    public TCP setSequence(int seq) {
        this.sequence = seq;
        return this;
    }

    public int getAcknowledge() {
        return this.acknowledge;
    }

    public TCP setAcknowledge(int ack) {
        this.acknowledge = ack;
        return this;
    }

    public byte getDataOffset() {
        return this.dataOffset;
    }

    public TCP setDataOffset(byte offset) {
        this.dataOffset = offset;
        return this;
    }

    public short getFlags() {
        return this.flags;
    }

    public TCP setFlags(short flags) {
        this.flags = flags;
        return this;
    }

    public short getWindowSize() {
        return this.windowSize;
    }

    public TCP setWindowSize(short windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    @Override
    public void resetChecksum() {
        this.checksum = 0;
        super.resetChecksum();
    }

    public short getUrgentPointer() {
        return this.urgentPointer;
    }

    public TCP setUrgentPointer(short urgentPointer) {
        this.urgentPointer = urgentPointer;
        return this;
    }

    public byte[] getOptions() {
        return this.options;
    }

    public TCP setOptions(byte[] options) {
        this.options = options;
        this.dataOffset = (byte)(20 + options.length + 3 >> 2);
        return this;
    }

    @Override
    public byte[] serialize() {
        int i;
        if (this.dataOffset == 0) {
            this.dataOffset = (byte)5;
        }
        int length = this.dataOffset << 2;
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
            length += payloadData.length;
        }
        byte[] data = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putShort(this.sourcePort);
        bb.putShort(this.destinationPort);
        bb.putInt(this.sequence);
        bb.putInt(this.acknowledge);
        bb.putShort((short)(this.flags | this.dataOffset << 12));
        bb.putShort(this.windowSize);
        bb.putShort(this.checksum);
        bb.putShort(this.urgentPointer);
        if (this.dataOffset > 5) {
            bb.put(this.options);
            int padding = (this.dataOffset << 2) - 20 - this.options.length;
            for (i = 0; i < padding; ++i) {
                bb.put((byte)0);
            }
        }
        if (payloadData != null) {
            bb.put(payloadData);
        }
        if (this.parent != null && this.parent instanceof IPv4) {
            ((IPv4)this.parent).setProtocol((byte)6);
        }
        if (this.checksum == 0) {
            bb.rewind();
            int accumulation = 0;
            if (this.parent != null) {
                if (this.parent instanceof IPv4) {
                    IPv4 ipv4 = (IPv4)this.parent;
                    accumulation += (ipv4.getSourceAddress() >> 16 & 0xFFFF) + (ipv4.getSourceAddress() & 0xFFFF);
                    accumulation += (ipv4.getDestinationAddress() >> 16 & 0xFFFF) + (ipv4.getDestinationAddress() & 0xFFFF);
                    accumulation += ipv4.getProtocol() & 0xFF;
                    accumulation += length & 0xFFFF;
                } else if (this.parent instanceof IPv6) {
                    IPv6 ipv6 = (IPv6)this.parent;
                    int bbLength = 38;
                    ByteBuffer bbChecksum = ByteBuffer.allocate(38);
                    bbChecksum.put(ipv6.getSourceAddress());
                    bbChecksum.put(ipv6.getDestinationAddress());
                    bbChecksum.put((byte)0);
                    bbChecksum.put(ipv6.getNextHeader());
                    bbChecksum.putInt(length);
                    bbChecksum.rewind();
                    for (int i2 = 0; i2 < 19; ++i2) {
                        accumulation += 0xFFFF & bbChecksum.getShort();
                    }
                }
            }
            for (i = 0; i < length / 2; ++i) {
                accumulation += 0xFFFF & bb.getShort();
            }
            if (length % 2 > 0) {
                accumulation += (bb.get() & 0xFF) << 8;
            }
            accumulation = (accumulation >> 16 & 0xFFFF) + (accumulation & 0xFFFF);
            this.checksum = (short)(~accumulation & 0xFFFF);
            bb.putShort(16, this.checksum);
        }
        return data;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.checksum;
        result = 5807 * result + this.destinationPort;
        result = 5807 * result + this.sourcePort;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TCP)) {
            return false;
        }
        TCP other = (TCP)obj;
        return this.checksum == other.checksum && this.destinationPort == other.destinationPort && this.sourcePort == other.sourcePort && this.sequence == other.sequence && this.acknowledge == other.acknowledge && this.dataOffset == other.dataOffset && this.flags == other.flags && this.windowSize == other.windowSize && this.urgentPointer == other.urgentPointer && (this.dataOffset == 5 || this.options.equals(other.options));
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        this.sourcePort = bb.getShort();
        this.destinationPort = bb.getShort();
        this.sequence = bb.getInt();
        this.acknowledge = bb.getInt();
        this.flags = bb.getShort();
        this.dataOffset = (byte)(this.flags >> 12 & 0xF);
        this.flags = (short)(this.flags & 0x1FF);
        this.windowSize = bb.getShort();
        this.checksum = bb.getShort();
        this.urgentPointer = bb.getShort();
        if (this.dataOffset > 5) {
            int optLength = (this.dataOffset << 2) - 20;
            if (bb.limit() < bb.position() + optLength) {
                optLength = bb.limit() - bb.position();
            }
            try {
                this.options = new byte[optLength];
                bb.get(this.options, 0, optLength);
            }
            catch (IndexOutOfBoundsException e) {
                this.options = null;
            }
        }
        this.payload = new Data();
        this.payload = this.payload.deserialize(data, bb.position(), bb.limit() - bb.position());
        this.payload.setParent(this);
        return this;
    }
}

