/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ipv6;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv6;
import org.onlab.packet.ipv6.IExtensionHeader;

public class Authentication
extends BasePacket
implements IExtensionHeader {
    public static final byte FIXED_HEADER_LENGTH = 12;
    public static final byte LENGTH_UNIT = 4;
    public static final byte MINUS = 2;
    protected byte nextHeader;
    protected byte payloadLength;
    protected int securityParamIndex;
    protected int sequence;
    protected byte[] integrityCheck;

    @Override
    public byte getNextHeader() {
        return this.nextHeader;
    }

    @Override
    public Authentication setNextHeader(byte nextHeader) {
        this.nextHeader = nextHeader;
        return this;
    }

    public byte getPayloadLength() {
        return this.payloadLength;
    }

    public Authentication setPayloadLength(byte payloadLength) {
        this.payloadLength = payloadLength;
        return this;
    }

    public int getSecurityParamIndex() {
        return this.securityParamIndex;
    }

    public Authentication setSecurityParamIndex(int securityParamIndex) {
        this.securityParamIndex = securityParamIndex;
        return this;
    }

    public int getSequence() {
        return this.sequence;
    }

    public Authentication setSequence(int sequence) {
        this.sequence = sequence;
        return this;
    }

    public byte[] getIntegrityCheck() {
        return this.integrityCheck;
    }

    public Authentication setIngegrityCheck(byte[] integrityCheck) {
        this.integrityCheck = Arrays.copyOfRange(integrityCheck, 0, integrityCheck.length);
        return this;
    }

    public int getTotalLength() {
        return (this.payloadLength + 2) * 4;
    }

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        int headerLength = 12 + this.integrityCheck.length;
        int payloadLength = 0;
        if (payloadData != null) {
            payloadLength = payloadData.length;
        }
        byte[] data = new byte[headerLength + payloadLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.nextHeader);
        bb.put(this.payloadLength);
        bb.putShort((short)0);
        bb.putInt(this.securityParamIndex);
        bb.putInt(this.sequence);
        bb.put(this.integrityCheck, 0, this.integrityCheck.length);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        if (this.parent != null && this.parent instanceof IExtensionHeader) {
            ((IExtensionHeader)((Object)this.parent)).setNextHeader((byte)51);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        IPacket payload;
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        this.nextHeader = bb.get();
        this.payloadLength = bb.get();
        bb.getShort();
        this.securityParamIndex = bb.getInt();
        this.sequence = bb.getInt();
        int icvLength = this.getTotalLength() - 12;
        this.integrityCheck = new byte[icvLength];
        bb.get(this.integrityCheck, 0, icvLength);
        if (IPv6.PROTOCOL_CLASS_MAP.containsKey(this.nextHeader)) {
            Class<? extends IPacket> clazz = IPv6.PROTOCOL_CLASS_MAP.get(this.nextHeader);
            try {
                payload = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing payload for Authentication packet", e);
            }
        } else {
            payload = new Data();
        }
        this.payload = payload.deserialize(data, bb.position(), bb.limit() - bb.position());
        this.payload.setParent(this);
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.nextHeader;
        result = 5807 * result + this.payloadLength;
        result = 5807 * result + this.securityParamIndex;
        result = 5807 * result + this.sequence;
        for (byte b : this.integrityCheck) {
            result = 5807 * result + b;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Authentication)) {
            return false;
        }
        Authentication other = (Authentication)obj;
        if (this.nextHeader != other.nextHeader) {
            return false;
        }
        if (this.payloadLength != other.payloadLength) {
            return false;
        }
        if (this.securityParamIndex != other.securityParamIndex) {
            return false;
        }
        if (this.sequence != other.sequence) {
            return false;
        }
        return Arrays.equals(this.integrityCheck, other.integrityCheck);
    }
}

