/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ipv6;

import java.nio.ByteBuffer;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.IPacket;
import org.onlab.packet.ipv6.IExtensionHeader;

public class EncapSecurityPayload
extends BasePacket {
    public static final byte HEADER_LENGTH = 8;
    protected int securityParamIndex;
    protected int sequence;

    public int getSecurityParamIndex() {
        return this.securityParamIndex;
    }

    public EncapSecurityPayload setSecurityParamIndex(int securityParamIndex) {
        this.securityParamIndex = securityParamIndex;
        return this;
    }

    public int getSequence() {
        return this.sequence;
    }

    public EncapSecurityPayload setSequence(int sequence) {
        this.sequence = sequence;
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        int payloadLength = 0;
        if (payloadData != null) {
            payloadLength = payloadData.length;
        }
        byte[] data = new byte[8 + payloadLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putInt(this.securityParamIndex);
        bb.putInt(this.sequence);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        if (this.parent != null && this.parent instanceof IExtensionHeader) {
            ((IExtensionHeader)((Object)this.parent)).setNextHeader((byte)50);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        this.securityParamIndex = bb.getInt();
        this.sequence = bb.getInt();
        this.payload = new Data();
        this.payload.deserialize(data, bb.position(), bb.limit() - bb.position());
        this.payload.setParent(this);
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.securityParamIndex;
        result = 5807 * result + this.sequence;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof EncapSecurityPayload)) {
            return false;
        }
        EncapSecurityPayload other = (EncapSecurityPayload)obj;
        if (this.securityParamIndex != other.securityParamIndex) {
            return false;
        }
        return this.sequence == other.sequence;
    }
}

