/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ndp;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.onlab.packet.BasePacket;
import org.onlab.packet.IPacket;
import org.onlab.packet.ndp.NeighborDiscoveryOptions;

public class NeighborSolicitation
extends BasePacket {
    public static final byte HEADER_LENGTH = 20;
    protected byte[] targetAddress = new byte[16];
    private final NeighborDiscoveryOptions options = new NeighborDiscoveryOptions();

    public byte[] getTargetAddress() {
        return this.targetAddress;
    }

    public NeighborSolicitation setTargetAddress(byte[] targetAddress) {
        this.targetAddress = Arrays.copyOfRange(targetAddress, 0, 16);
        return this;
    }

    public List<NeighborDiscoveryOptions.Option> getOptions() {
        return this.options.options();
    }

    public NeighborSolicitation addOption(byte type, byte[] data) {
        this.options.addOption(type, data);
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] optionsData = null;
        if (this.options.hasOptions()) {
            optionsData = this.options.serialize();
        }
        int optionsLength = 0;
        if (optionsData != null) {
            optionsLength = optionsData.length;
        }
        byte[] data = new byte[20 + optionsLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putInt(0);
        bb.put(this.targetAddress, 0, 16);
        if (optionsData != null) {
            bb.put(optionsData);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        bb.getInt();
        bb.get(this.targetAddress, 0, 16);
        this.options.deserialize(data, bb.position(), bb.limit() - bb.position());
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        ByteBuffer bb = ByteBuffer.wrap(this.targetAddress);
        for (int i = 0; i < this.targetAddress.length / 4; ++i) {
            result = 5807 * result + bb.getInt();
        }
        result = 5807 * result + this.options.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof NeighborSolicitation)) {
            return false;
        }
        NeighborSolicitation other = (NeighborSolicitation)obj;
        if (!Arrays.equals(this.targetAddress, other.targetAddress)) {
            return false;
        }
        return this.options.equals(other.options);
    }
}

