/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.collect.ComparisonChain;
import java.util.Objects;
import org.onlab.util.RichComparable;

public final class Bandwidth
implements RichComparable<Bandwidth> {
    private final double bps;

    private Bandwidth(double bps) {
        this.bps = bps;
    }

    private Bandwidth() {
        this.bps = 0.0;
    }

    public static Bandwidth bps(double bps) {
        return new Bandwidth(bps);
    }

    public static Bandwidth kbps(double kbps) {
        return Bandwidth.bps(kbps * 1000.0);
    }

    public static Bandwidth mbps(double mbps) {
        return Bandwidth.bps(mbps * 1000000.0);
    }

    public static Bandwidth gbps(double gbps) {
        return Bandwidth.bps(gbps * 1.0E9);
    }

    public double bps() {
        return this.bps;
    }

    public Bandwidth add(Bandwidth value) {
        return Bandwidth.bps(this.bps + value.bps);
    }

    public Bandwidth subtract(Bandwidth value) {
        return Bandwidth.bps(this.bps - value.bps);
    }

    @Override
    public int compareTo(Bandwidth other) {
        return ComparisonChain.start().compare(this.bps, other.bps).result();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bandwidth) {
            Bandwidth that = (Bandwidth)obj;
            return Objects.equals(this.bps, that.bps);
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(Double.doubleToLongBits(this.bps));
    }

    public String toString() {
        return String.valueOf(this.bps);
    }
}

