/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.DHCP;
import org.onlab.packet.DHCPOption;
import org.onlab.packet.Deserializer;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;

public class DhcpTest {
    private Deserializer<DHCP> deserializer = DHCP.deserializer();
    private byte opCode = 1;
    private byte hardwareType = 1;
    private byte hardwareAddressLength = (byte)6;
    private byte hops = 0;
    private int transactionId = 785705808;
    private short seconds = 0;
    private short flags = 0;
    private int clientIpAddress = 1;
    private int yourIpAddress = 2;
    private int serverIpAddress = 3;
    private int gatewayIpAddress = 4;
    private byte[] clientHardwareAddress = MacAddress.valueOf((long)500L).toBytes();
    private String serverName = "test-server";
    private String bootFileName = "test-file";
    private String hostName = "test-host";
    private DHCPOption hostNameOption = new DHCPOption();
    private byte[] byteHeader;

    @Before
    public void setUp() {
        this.hostNameOption.setCode((byte)55);
        this.hostNameOption.setLength((byte)this.hostName.length());
        this.hostNameOption.setData(this.hostName.getBytes(Charsets.US_ASCII));
        ByteBuffer bb = ByteBuffer.allocate(242 + this.hostNameOption.getLength() + 1);
        bb.put(this.opCode);
        bb.put(this.hardwareType);
        bb.put(this.hardwareAddressLength);
        bb.put(this.hops);
        bb.putInt(this.transactionId);
        bb.putShort(this.seconds);
        bb.putShort(this.flags);
        bb.putInt(this.clientIpAddress);
        bb.putInt(this.yourIpAddress);
        bb.putInt(this.serverIpAddress);
        bb.putInt(this.gatewayIpAddress);
        bb.put(this.clientHardwareAddress);
        bb.put(new byte[16 - this.hardwareAddressLength]);
        bb.put(this.serverName.getBytes(Charsets.US_ASCII));
        bb.put(new byte[64 - this.serverName.length()]);
        bb.put(this.bootFileName.getBytes(Charsets.US_ASCII));
        bb.put(new byte[128 - this.bootFileName.length()]);
        bb.put("DHCP".getBytes(Charsets.US_ASCII));
        bb.put(this.hostNameOption.getCode());
        bb.put(this.hostNameOption.getLength());
        bb.put(this.hostNameOption.getData());
        bb.put((byte)-1);
        this.byteHeader = bb.array();
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.byteHeader);
    }

    @Test
    public void testDeserialize() throws Exception {
        DHCP dhcp = (DHCP)this.deserializer.deserialize(this.byteHeader, 0, this.byteHeader.length);
        Assert.assertEquals((long)this.opCode, (long)dhcp.opCode);
        Assert.assertEquals((long)this.hardwareType, (long)dhcp.hardwareType);
        Assert.assertEquals((long)this.hardwareAddressLength, (long)dhcp.hardwareAddressLength);
        Assert.assertEquals((long)this.hops, (long)dhcp.hops);
        Assert.assertEquals((long)this.transactionId, (long)dhcp.transactionId);
        Assert.assertEquals((long)this.seconds, (long)dhcp.seconds);
        Assert.assertEquals((long)this.flags, (long)dhcp.flags);
        Assert.assertEquals((long)this.clientIpAddress, (long)dhcp.clientIPAddress);
        Assert.assertEquals((long)this.yourIpAddress, (long)dhcp.yourIPAddress);
        Assert.assertEquals((long)this.serverIpAddress, (long)dhcp.serverIPAddress);
        Assert.assertEquals((long)this.gatewayIpAddress, (long)dhcp.gatewayIPAddress);
        Assert.assertTrue((boolean)Arrays.equals(this.clientHardwareAddress, dhcp.clientHardwareAddress));
        Assert.assertEquals((Object)this.serverName, (Object)dhcp.serverName);
        Assert.assertEquals((Object)this.bootFileName, (Object)dhcp.bootFileName);
        Assert.assertEquals((long)2L, (long)dhcp.options.size());
        Assert.assertEquals((Object)this.hostNameOption, dhcp.options.get(0));
    }
}

