/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.ICMP;
import org.onlab.packet.PacketTestUtils;

public class ICMPTest {
    private Deserializer<ICMP> deserializer;
    private byte icmpType = (byte)8;
    private byte icmpCode = (byte)4;
    private short checksum = (short)870;
    private byte[] headerBytes;

    @Before
    public void setUp() throws Exception {
        this.deserializer = ICMP.deserializer();
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.put(this.icmpType);
        bb.put(this.icmpCode);
        bb.putShort(this.checksum);
        this.headerBytes = bb.array();
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.headerBytes);
    }

    @Test
    public void testDeserialize() throws Exception {
        ICMP icmp = (ICMP)this.deserializer.deserialize(this.headerBytes, 0, this.headerBytes.length);
        Assert.assertEquals((long)this.icmpType, (long)icmp.getIcmpType());
        Assert.assertEquals((long)this.icmpCode, (long)icmp.getIcmpCode());
        Assert.assertEquals((long)this.checksum, (long)icmp.getChecksum());
    }
}

