/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPv4;
import org.onlab.packet.PacketTestUtils;

public class IPv4Test {
    private Deserializer<IPv4> deserializer;
    private byte version = (byte)4;
    private byte headerLength = (byte)6;
    private byte diffServ = (byte)2;
    private short totalLength = (short)20;
    private short identification = 1;
    private byte flags = 1;
    private short fragmentOffset = 1;
    private byte ttl = (byte)60;
    private byte protocol = (byte)4;
    private short checksum = (short)4;
    private int sourceAddress = 1;
    private int destinationAddress = 2;
    private byte[] options = new byte[]{1, 2, 3, 4};
    private byte[] headerBytes;

    @Before
    public void setUp() throws Exception {
        this.deserializer = IPv4.deserializer();
        ByteBuffer bb = ByteBuffer.allocate(this.headerLength * 4);
        bb.put((byte)((this.version & 0xF) << 4 | this.headerLength & 0xF));
        bb.put(this.diffServ);
        bb.putShort(this.totalLength);
        bb.putShort(this.identification);
        bb.putShort((short)((this.flags & 7) << 13 | this.fragmentOffset & 0x1FFF));
        bb.put(this.ttl);
        bb.put(this.protocol);
        bb.putShort(this.checksum);
        bb.putInt(this.sourceAddress);
        bb.putInt(this.destinationAddress);
        bb.put(this.options);
        this.headerBytes = bb.array();
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.headerBytes);
    }

    @Test
    public void testDeserialize() throws Exception {
        IPv4 ipv4 = (IPv4)this.deserializer.deserialize(this.headerBytes, 0, this.headerBytes.length);
        Assert.assertEquals((long)this.version, (long)ipv4.getVersion());
        Assert.assertEquals((long)this.headerLength, (long)ipv4.getHeaderLength());
        Assert.assertEquals((long)this.diffServ, (long)ipv4.getDiffServ());
        Assert.assertEquals((long)this.totalLength, (long)ipv4.getTotalLength());
        Assert.assertEquals((long)this.identification, (long)ipv4.getIdentification());
        Assert.assertEquals((long)this.flags, (long)ipv4.getFlags());
        Assert.assertEquals((long)this.fragmentOffset, (long)ipv4.getFragmentOffset());
        Assert.assertEquals((long)this.ttl, (long)ipv4.getTtl());
        Assert.assertEquals((long)this.protocol, (long)ipv4.getProtocol());
        Assert.assertEquals((long)this.checksum, (long)ipv4.getChecksum());
        Assert.assertEquals((long)this.sourceAddress, (long)ipv4.getSourceAddress());
        Assert.assertEquals((long)this.destinationAddress, (long)ipv4.getDestinationAddress());
        Assert.assertTrue((boolean)ipv4.isTruncated());
    }
}

