/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.Ip6Prefix;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;

public class IpPrefixTest {
    @Test
    public void testImmutable() {
        ImmutableClassChecker.assertThatClassIsImmutableBaseClass(IpPrefix.class);
    }

    @Test
    public void testMaxMaskLength() {
        Assert.assertThat((Object)32, (Matcher)Matchers.is((Object)32));
        Assert.assertThat((Object)128, (Matcher)Matchers.is((Object)128));
    }

    @Test
    public void testVersion() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"0.0.0.0/0");
        Assert.assertThat((Object)ipPrefix.version(), (Matcher)Matchers.is((Object)IpAddress.Version.INET));
        ipPrefix = IpPrefix.valueOf((String)"::/0");
        Assert.assertThat((Object)ipPrefix.version(), (Matcher)Matchers.is((Object)IpAddress.Version.INET6));
    }

    @Test
    public void testIsIp4() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"0.0.0.0/0");
        Assert.assertTrue((boolean)ipPrefix.isIp4());
        ipPrefix = IpPrefix.valueOf((String)"::/0");
        Assert.assertFalse((boolean)ipPrefix.isIp4());
    }

    @Test
    public void testIsIp6() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"0.0.0.0/0");
        Assert.assertFalse((boolean)ipPrefix.isIp6());
        ipPrefix = IpPrefix.valueOf((String)"::/0");
        Assert.assertTrue((boolean)ipPrefix.isIp6());
    }

    @Test
    public void testAddressAndPrefixLengthIPv4() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1.2.3.0/24");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)IpAddress.valueOf((String)"1.2.3.0")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)24));
        ipPrefix = IpPrefix.valueOf((String)"1.2.3.4/24");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)IpAddress.valueOf((String)"1.2.3.0")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)24));
        ipPrefix = IpPrefix.valueOf((String)"1.2.3.4/32");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)IpAddress.valueOf((String)"1.2.3.4")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)32));
        ipPrefix = IpPrefix.valueOf((String)"1.2.3.5/32");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)IpAddress.valueOf((String)"1.2.3.5")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)32));
        ipPrefix = IpPrefix.valueOf((String)"0.0.0.0/0");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)IpAddress.valueOf((String)"0.0.0.0")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)0));
        ipPrefix = IpPrefix.valueOf((String)"255.255.255.255/32");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)IpAddress.valueOf((String)"255.255.255.255")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)32));
    }

    @Test
    public void testAddressAndPrefixLengthIPv6() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1100::/8");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)IpAddress.valueOf((String)"1100::")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)8));
        ipPrefix = IpPrefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885/8");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)IpAddress.valueOf((String)"1100::")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)8));
        ipPrefix = IpPrefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8800/120");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8800")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)120));
        ipPrefix = IpPrefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885/128");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)128));
        ipPrefix = IpPrefix.valueOf((String)"::/0");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)IpAddress.valueOf((String)"::")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)0));
        ipPrefix = IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)IpAddress.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)128));
        ipPrefix = IpPrefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885/64");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)IpAddress.valueOf((String)"1111:2222:3333:4444::")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)64));
    }

    @Test
    public void testGetIp4AndIp6PrefixView() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1.2.3.0/24");
        Ip4Prefix ip4Prefix = ipPrefix.getIp4Prefix();
        Ip6Prefix ip6Prefix = ipPrefix.getIp6Prefix();
        Assert.assertThat((Object)ip4Prefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.0/24"));
        Assert.assertNull((Object)ip6Prefix);
        ipPrefix = Ip4Prefix.valueOf((String)"1.2.3.0/24");
        ip4Prefix = ipPrefix.getIp4Prefix();
        ip6Prefix = ipPrefix.getIp6Prefix();
        Assert.assertThat((Object)ip4Prefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.0/24"));
        Assert.assertNull((Object)ip6Prefix);
        ipPrefix = IpPrefix.valueOf((String)"1111:2222::/64");
        ip4Prefix = ipPrefix.getIp4Prefix();
        ip6Prefix = ipPrefix.getIp6Prefix();
        Assert.assertNull((Object)ip4Prefix);
        Assert.assertThat((Object)ip6Prefix.toString(), (Matcher)Matchers.is((Object)"1111:2222::/64"));
        ipPrefix = Ip6Prefix.valueOf((String)"1111:2222::/64");
        ip4Prefix = ipPrefix.getIp4Prefix();
        ip6Prefix = ipPrefix.getIp6Prefix();
        Assert.assertNull((Object)ip4Prefix);
        Assert.assertThat((Object)ip6Prefix.toString(), (Matcher)Matchers.is((Object)"1111:2222::/64"));
    }

    @Test
    public void testValueOfForIntegerIPv4() {
        IpPrefix ipPrefix = IpPrefix.valueOf((int)16909060, (int)24);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.0/24"));
        ipPrefix = IpPrefix.valueOf((int)16909060, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.4/32"));
        ipPrefix = IpPrefix.valueOf((int)16909061, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.5/32"));
        ipPrefix = IpPrefix.valueOf((int)0, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = IpPrefix.valueOf((int)0, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/32"));
        ipPrefix = IpPrefix.valueOf((int)-1, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = IpPrefix.valueOf((int)-1, (int)16);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.0.0/16"));
        ipPrefix = IpPrefix.valueOf((int)-1, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.255.255/32"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfIntegerNegativePrefixLengthIPv4() {
        IpPrefix ipPrefix = IpPrefix.valueOf((int)16909060, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfIntegerTooLongPrefixLengthIPv4() {
        IpPrefix ipPrefix = IpPrefix.valueOf((int)16909060, (int)33);
    }

    @Test
    public void testValueOfByteArrayIPv4() {
        byte[] value = new byte[]{1, 2, 3, 4};
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)24);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.0/24"));
        ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.4/32"));
        value = new byte[]{1, 2, 3, 5};
        ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.5/32"));
        value = new byte[]{0, 0, 0, 0};
        ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/32"));
        value = new byte[]{-1, -1, -1, -1};
        ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)16);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.0.0/16"));
        ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.255.255/32"));
    }

    @Test
    public void testValueOfByteArrayIPv6() {
        byte[] value = new byte[]{17, 17, 34, 34, 51, 51, 68, 68, 85, 85, 102, 102, 119, 119, -120, -120};
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value, (int)120);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8800/120"));
        ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value, (int)128);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888/128"));
        value = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/0"));
        ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value, (int)128);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/128"));
        value = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/0"));
        ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value, (int)64);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff::/64"));
        ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value, (int)128);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullArrayIPv4() {
        byte[] value = null;
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, value, (int)24);
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullArrayIPv6() {
        byte[] value = null;
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET6, value, (int)120);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfShortArrayIPv4() {
        byte[] value = new byte[]{1, 2, 3};
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)24);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfShortArrayIPv6() {
        byte[] value = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value, (int)120);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfByteArrayNegativePrefixLengthIPv4() {
        byte[] value = new byte[]{1, 2, 3, 4};
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfByteArrayNegativePrefixLengthIPv6() {
        byte[] value = new byte[]{17, 17, 34, 34, 51, 51, 68, 68, 85, 85, 102, 102, 119, 119, -120, -120};
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfByteArrayTooLongPrefixLengthIPv4() {
        byte[] value = new byte[]{1, 2, 3, 4};
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])value, (int)33);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfByteArrayTooLongPrefixLengthIPv6() {
        byte[] value = new byte[]{17, 17, 34, 34, 51, 51, 68, 68, 85, 85, 102, 102, 119, 119, -120, -120};
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])value, (int)129);
    }

    @Test
    public void testValueOfAddressIPv4() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1.2.3.4");
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)24);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.0/24"));
        ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.4/32"));
        ipAddress = IpAddress.valueOf((String)"1.2.3.5");
        ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.5/32"));
        ipAddress = IpAddress.valueOf((String)"0.0.0.0");
        ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/32"));
        ipAddress = IpAddress.valueOf((String)"255.255.255.255");
        ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)16);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.0.0/16"));
        ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.255.255/32"));
    }

    @Test
    public void testValueOfAddressIPv6() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)120);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8800/120"));
        ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)128);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888/128"));
        ipAddress = IpAddress.valueOf((String)"::");
        ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/0"));
        ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)128);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/128"));
        ipAddress = IpAddress.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
        ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/0"));
        ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)64);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff::/64"));
        ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)128);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullAddress() {
        IpAddress ipAddress = null;
        IpPrefix ipPrefix = IpPrefix.valueOf(ipAddress, (int)24);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfAddressNegativePrefixLengthIPv4() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1.2.3.4");
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfAddressNegativePrefixLengthIPv6() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfAddressTooLongPrefixLengthIPv4() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1.2.3.4");
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)33);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfAddressTooLongPrefixLengthIPv6() {
        IpAddress ipAddress = IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888");
        IpPrefix ipPrefix = IpPrefix.valueOf((IpAddress)ipAddress, (int)129);
    }

    @Test
    public void testValueOfStringIPv4() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1.2.3.4/24");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.0/24"));
        ipPrefix = IpPrefix.valueOf((String)"1.2.3.4/32");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.4/32"));
        ipPrefix = IpPrefix.valueOf((String)"1.2.3.5/32");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.5/32"));
        ipPrefix = IpPrefix.valueOf((String)"0.0.0.0/0");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = IpPrefix.valueOf((String)"0.0.0.0/32");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/32"));
        ipPrefix = IpPrefix.valueOf((String)"255.255.255.255/0");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = IpPrefix.valueOf((String)"255.255.255.255/16");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.0.0/16"));
        ipPrefix = IpPrefix.valueOf((String)"255.255.255.255/32");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.255.255/32"));
    }

    @Test
    public void testValueOfStringIPv6() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888/120");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8800/120"));
        ipPrefix = IpPrefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888/128");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1111:2222:3333:4444:5555:6666:7777:8888/128"));
        ipPrefix = IpPrefix.valueOf((String)"::/0");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/0"));
        ipPrefix = IpPrefix.valueOf((String)"::/128");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/128"));
        ipPrefix = IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/0");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/0"));
        ipPrefix = IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/64");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff::/64"));
        ipPrefix = IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullString() {
        String fromString = null;
        IpPrefix ipPrefix = IpPrefix.valueOf(fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfEmptyString() {
        String fromString = "";
        IpPrefix ipPrefix = IpPrefix.valueOf((String)fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfIncorrectString() {
        String fromString = "NoSuchIpPrefix";
        IpPrefix ipPrefix = IpPrefix.valueOf((String)fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfStringNegativePrefixLengthIPv4() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1.2.3.4/-1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfStringNegativePrefixLengthIPv6() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888/-1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfStringTooLongPrefixLengthIPv4() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1.2.3.4/33");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfStringTooLongPrefixLengthIPv6() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8888/129");
    }

    @Test
    public void testContainsIpPrefixIPv4() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1.2.0.0/24");
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.0/24")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.0/32")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.4/32")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.0/16")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.3.0.0/24")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"0.0.0.0/16")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"0.0.0.0/0")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"255.255.255.255/32")));
        ipPrefix = IpPrefix.valueOf((String)"1.2.0.0/32");
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.0/24")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.0/32")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.4/32")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.0/16")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.3.0.0/24")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"0.0.0.0/16")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"0.0.0.0/0")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"255.255.255.255/32")));
        ipPrefix = IpPrefix.valueOf((String)"0.0.0.0/0");
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.0/24")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.0/32")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.4/32")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.0/16")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.3.0.0/24")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"0.0.0.0/16")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"0.0.0.0/0")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"255.255.255.255/32")));
        ipPrefix = IpPrefix.valueOf((String)"255.255.255.255/32");
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.0/24")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.0/32")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.4/32")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.0/16")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.3.0.0/24")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"0.0.0.0/16")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"0.0.0.0/0")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"255.255.255.255/32")));
        ipPrefix = IpPrefix.valueOf((String)"0.0.0.0/0");
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::/120")));
        ipPrefix = IpPrefix.valueOf((String)"255.255.255.255/32");
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128")));
    }

    @Test
    public void testContainsIpPrefixIPv6() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1111:2222:3333:4444::/120");
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::/120")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::/128")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::1/128")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::/64")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4445::/120")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"::/64")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"::/0")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128")));
        ipPrefix = IpPrefix.valueOf((String)"1111:2222:3333:4444::/128");
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::/120")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::/128")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::1/128")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::/64")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4445::/120")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"::/64")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"::/0")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128")));
        ipPrefix = IpPrefix.valueOf((String)"::/0");
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::/120")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::/128")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::1/128")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::/64")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4445::/120")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"::/64")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"::/0")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128")));
        ipPrefix = IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128");
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::/120")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::/128")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::1/128")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4444::/64")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1111:2222:3333:4445::/120")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"::/64")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"::/0")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128")));
        ipPrefix = IpPrefix.valueOf((String)"::/0");
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"1.2.0.0/24")));
        ipPrefix = IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128");
        Assert.assertFalse((boolean)ipPrefix.contains(IpPrefix.valueOf((String)"255.255.255.255/32")));
    }

    @Test
    public void testContainsIpAddressIPv4() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1.2.0.0/24");
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1.2.0.0")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1.2.0.4")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1.3.0.0")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"0.0.0.0")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"255.255.255.255")));
        ipPrefix = IpPrefix.valueOf((String)"1.2.0.0/32");
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1.2.0.0")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1.2.0.4")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1.3.0.0")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"0.0.0.0")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"255.255.255.255")));
        ipPrefix = IpPrefix.valueOf((String)"0.0.0.0/0");
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1.2.0.0")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1.2.0.4")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1.3.0.0")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"0.0.0.0")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"255.255.255.255")));
        ipPrefix = IpPrefix.valueOf((String)"255.255.255.255/32");
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1.2.0.0")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1.2.0.4")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1.3.0.0")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"0.0.0.0")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"255.255.255.255")));
        ipPrefix = IpPrefix.valueOf((String)"0.0.0.0/0");
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1111:2222:3333:4444::")));
        ipPrefix = IpPrefix.valueOf((String)"255.255.255.255/32");
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff")));
    }

    @Test
    public void testContainsIpAddressIPv6() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1111:2222:3333:4444::/120");
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1111:2222:3333:4444::")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1111:2222:3333:4444::1")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1111:2222:3333:4445::")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"::")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff")));
        ipPrefix = IpPrefix.valueOf((String)"1111:2222:3333:4444::/128");
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1111:2222:3333:4444::")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1111:2222:3333:4444::1")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1111:2222:3333:4445::")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"::")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff")));
        ipPrefix = IpPrefix.valueOf((String)"::/0");
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1111:2222:3333:4444::")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1111:2222:3333:4444::1")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1111:2222:3333:4445::")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"::")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff")));
        ipPrefix = IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128");
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1111:2222:3333:4444::")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1111:2222:3333:4444::1")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1111:2222:3333:4445::")));
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"::")));
        Assert.assertTrue((boolean)ipPrefix.contains(IpAddress.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff")));
        ipPrefix = IpPrefix.valueOf((String)"::/0");
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"1.2.0.0")));
        ipPrefix = IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128");
        Assert.assertFalse((boolean)ipPrefix.contains(IpAddress.valueOf((String)"255.255.255.255")));
    }

    @Test
    public void testEqualityIPv4() {
        new EqualsTester().addEqualityGroup(new Object[]{IpPrefix.valueOf((String)"1.2.0.0/24"), IpPrefix.valueOf((String)"1.2.0.0/24"), IpPrefix.valueOf((String)"1.2.0.4/24")}).addEqualityGroup(new Object[]{IpPrefix.valueOf((String)"1.2.0.0/16"), IpPrefix.valueOf((String)"1.2.0.0/16")}).addEqualityGroup(new Object[]{IpPrefix.valueOf((String)"1.2.0.0/32"), IpPrefix.valueOf((String)"1.2.0.0/32")}).addEqualityGroup(new Object[]{IpPrefix.valueOf((String)"1.3.0.0/24"), IpPrefix.valueOf((String)"1.3.0.0/24")}).addEqualityGroup(new Object[]{IpPrefix.valueOf((String)"0.0.0.0/0"), IpPrefix.valueOf((String)"0.0.0.0/0")}).addEqualityGroup(new Object[]{IpPrefix.valueOf((String)"255.255.255.255/32"), IpPrefix.valueOf((String)"255.255.255.255/32")}).testEquals();
    }

    @Test
    public void testEqualityIPv6() {
        new EqualsTester().addEqualityGroup(new Object[]{IpPrefix.valueOf((String)"1111:2222:3333:4444::/120"), IpPrefix.valueOf((String)"1111:2222:3333:4444::1/120"), IpPrefix.valueOf((String)"1111:2222:3333:4444::/120")}).addEqualityGroup(new Object[]{IpPrefix.valueOf((String)"1111:2222:3333:4444::/64"), IpPrefix.valueOf((String)"1111:2222:3333:4444::/64")}).addEqualityGroup(new Object[]{IpPrefix.valueOf((String)"1111:2222:3333:4444::/128"), IpPrefix.valueOf((String)"1111:2222:3333:4444::/128")}).addEqualityGroup(new Object[]{IpPrefix.valueOf((String)"1111:2222:3333:4445::/64"), IpPrefix.valueOf((String)"1111:2222:3333:4445::/64")}).addEqualityGroup(new Object[]{IpPrefix.valueOf((String)"::/0"), IpPrefix.valueOf((String)"::/0")}).addEqualityGroup(new Object[]{IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128"), IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128")}).testEquals();
    }

    @Test
    public void testToStringIPv4() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1.2.3.0/24");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.0/24"));
        ipPrefix = IpPrefix.valueOf((String)"1.2.3.4/24");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.0/24"));
        ipPrefix = IpPrefix.valueOf((String)"0.0.0.0/0");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = IpPrefix.valueOf((String)"255.255.255.255/32");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.255.255/32"));
    }

    @Test
    public void testToStringIPv6() {
        IpPrefix ipPrefix = IpPrefix.valueOf((String)"1100::/8");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1100::/8"));
        ipPrefix = IpPrefix.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885/8");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1100::/8"));
        ipPrefix = IpPrefix.valueOf((String)"::/0");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"::/0"));
        ipPrefix = IpPrefix.valueOf((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128"));
    }
}

