/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.PIM;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.pim.PIMAddrUnicast;
import org.onlab.packet.pim.PIMHello;
import org.onlab.packet.pim.PIMJoinPrune;

public final class PIMTest {
    public static final String SADDR = "10.2.1.2";
    public static final String PIMADDR = "224.0.0.13";
    public static final String PIMUADDR = "10.23.3.5";
    public static final String SADDR1 = "10.1.1.1/32";
    public static final String SADDR2 = "10.1.2.1/32";
    public static final String GADDR1 = "232.1.1.1/32";
    public static final String GADDR2 = "232.1.2.1/32";
    public static final String CPSTR1 = "of:deadbeefball/8";
    public static final String CPSTR2 = "of:deadbeefcafe/3";
    public static final String CPSTR3 = "of:2badcafef00d/3";
    private Deserializer<PIM> deserializer;
    private PIM pimHello;
    private PIMHello hello;
    private PIM pimJoinPrune;
    private PIMJoinPrune joinPrune;

    @Before
    public void setUp() throws Exception {
        this.pimHello = new PIM();
        this.pimHello.setVersion((byte)2);
        this.pimHello.setPIMType((byte)0);
        this.pimHello.setChecksum((short)0);
        this.hello = new PIMHello();
        this.hello.addHoldtime(210);
        this.hello.addPriority(44);
        this.hello.addGenId(61453);
        this.pimHello.setPayload((IPacket)this.hello);
        this.hello.setParent((IPacket)this.pimHello);
        this.pimJoinPrune = new PIM();
        this.pimJoinPrune.setVersion((byte)2);
        this.pimJoinPrune.setPIMType((byte)3);
        this.pimJoinPrune.setChecksum((short)0);
        this.joinPrune = new PIMJoinPrune();
        this.joinPrune.setUpstreamAddr(new PIMAddrUnicast(SADDR));
        this.joinPrune.addJoin(GADDR1, SADDR1);
        this.joinPrune.addJoin(GADDR2, SADDR2);
        this.joinPrune.addPrune(GADDR1, SADDR2);
        this.joinPrune.addPrune(GADDR2, SADDR1);
        this.pimJoinPrune.setPayload((IPacket)this.joinPrune);
        this.joinPrune.setParent((IPacket)this.pimJoinPrune);
        this.deserializer = PIM.deserializer();
    }

    @Test
    public void testDerserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        byte[] bits = this.pimJoinPrune.serialize();
        PacketTestUtils.testDeserializeTruncated(this.deserializer, bits);
    }

    @Test
    public void testDeserializeHello() throws Exception {
        byte[] data = this.pimHello.serialize();
        PIM pim = (PIM)this.deserializer.deserialize(data, 0, data.length);
        Assert.assertTrue((boolean)pim.equals((Object)this.pimHello));
    }

    @Test
    public void testDeserializeJoinPrune() throws Exception {
        byte[] data = this.pimJoinPrune.serialize();
        PIM pim = (PIM)this.deserializer.deserialize(data, 0, data.length);
        Assert.assertTrue((boolean)pim.equals((Object)this.pimJoinPrune));
    }
}

