/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.TCP;

public class TCPTest {
    private static final byte[] IPV4_SOURCE_ADDRESS = new byte[]{-64, -88, 1, 1};
    private static final byte[] IPV4_DESTINATION_ADDRESS = new byte[]{-64, -88, 1, 2};
    private static final byte[] IPV6_SOURCE_ADDRESS = new byte[]{-2, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private static final byte[] IPV6_DESTINATION_ADDRESS = new byte[]{-2, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2};
    private static IPv4 ipv4 = new IPv4();
    private static IPv6 ipv6 = new IPv6();
    private static byte[] bytePacketTCP4 = new byte[]{0, 80, 0, 96, 0, 0, 0, 16, 0, 0, 0, 32, 80, 2, 16, 0, 27, -82, 0, 1};
    private static byte[] bytePacketTCP6 = new byte[]{0, 80, 0, 96, 0, 0, 0, 16, 0, 0, 0, 32, 80, 2, 16, 0, -95, -3, 0, 1};
    private static Deserializer<TCP> deserializer;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        deserializer = TCP.deserializer();
        ipv4.setSourceAddress(IPv4.toIPv4Address((byte[])IPV4_SOURCE_ADDRESS));
        ipv4.setDestinationAddress(IPv4.toIPv4Address((byte[])IPV4_DESTINATION_ADDRESS));
        ipv4.setProtocol((byte)6);
        ipv6.setSourceAddress(IPV6_SOURCE_ADDRESS);
        ipv6.setDestinationAddress(IPV6_DESTINATION_ADDRESS);
        ipv6.setNextHeader((byte)6);
    }

    @Test
    public void testSerialize() {
        TCP tcp = new TCP();
        tcp.setSourcePort(80);
        tcp.setDestinationPort(96);
        tcp.setSequence(16);
        tcp.setAcknowledge(32);
        tcp.setDataOffset((byte)5);
        tcp.setFlags((short)2);
        tcp.setWindowSize((short)4096);
        tcp.setUrgentPointer((short)1);
        tcp.setParent((IPacket)ipv4);
        Assert.assertArrayEquals((byte[])bytePacketTCP4, (byte[])tcp.serialize());
        tcp.resetChecksum();
        tcp.setParent((IPacket)ipv6);
        Assert.assertArrayEquals((byte[])bytePacketTCP6, (byte[])tcp.serialize());
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(deserializer, bytePacketTCP4);
    }

    @Test
    public void testDeserialize() throws Exception {
        TCP tcp = (TCP)deserializer.deserialize(bytePacketTCP4, 0, bytePacketTCP4.length);
        Assert.assertThat((Object)tcp.getSourcePort(), (Matcher)Matchers.is((Object)80));
        Assert.assertThat((Object)tcp.getDestinationPort(), (Matcher)Matchers.is((Object)96));
        Assert.assertThat((Object)tcp.getSequence(), (Matcher)Matchers.is((Object)16));
        Assert.assertThat((Object)tcp.getAcknowledge(), (Matcher)Matchers.is((Object)32));
        Assert.assertThat((Object)tcp.getDataOffset(), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)tcp.getFlags(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)tcp.getWindowSize(), (Matcher)Matchers.is((Object)4096));
        Assert.assertThat((Object)tcp.getUrgentPointer(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)tcp.getChecksum(), (Matcher)Matchers.is((Object)7086));
    }

    @Test
    public void testEqual() {
        TCP tcp1 = new TCP();
        tcp1.setSourcePort(80);
        tcp1.setDestinationPort(96);
        tcp1.setSequence(16);
        tcp1.setAcknowledge(32);
        tcp1.setDataOffset((byte)5);
        tcp1.setFlags((short)2);
        tcp1.setWindowSize((short)4096);
        tcp1.setUrgentPointer((short)1);
        TCP tcp2 = new TCP();
        tcp2.setSourcePort(112);
        tcp2.setDestinationPort(96);
        tcp2.setSequence(16);
        tcp2.setAcknowledge(32);
        tcp2.setDataOffset((byte)5);
        tcp2.setFlags((short)2);
        tcp2.setWindowSize((short)4096);
        tcp2.setUrgentPointer((short)1);
        Assert.assertTrue((boolean)tcp1.equals((Object)tcp1));
        Assert.assertFalse((boolean)tcp1.equals((Object)tcp2));
    }
}

