/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ipv6;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.Data;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.UDP;
import org.onlab.packet.ipv6.Authentication;

public class AuthenticationTest {
    private static Data data;
    private static UDP udp;
    private static byte[] icv;
    private static byte[] bytePacket;
    private Deserializer<Authentication> deserializer;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        data = new Data();
        data.setData("testSerialize".getBytes());
        udp = new UDP();
        udp.setPayload((IPacket)data);
        byte[] bytePayload = udp.serialize();
        byte[] byteHeader = new byte[]{17, 2, 0, 0, 19, 87, 36, 104, 0, -1, -1, 0, 17, 34, 51, 68};
        bytePacket = new byte[byteHeader.length + bytePayload.length];
        System.arraycopy(byteHeader, 0, bytePacket, 0, byteHeader.length);
        System.arraycopy(bytePayload, 0, bytePacket, byteHeader.length, bytePayload.length);
    }

    @Before
    public void setUp() {
        this.deserializer = Authentication.deserializer();
    }

    @Test
    public void testSerialize() {
        Authentication auth = new Authentication();
        auth.setNextHeader((byte)17);
        auth.setPayloadLength((byte)2);
        auth.setSecurityParamIndex(324478056);
        auth.setSequence(0xFFFF00);
        auth.setIngegrityCheck(icv);
        auth.setPayload((IPacket)udp);
        Assert.assertArrayEquals((byte[])auth.serialize(), (byte[])bytePacket);
    }

    @Test
    public void testDeserialize() throws Exception {
        Authentication auth = (Authentication)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        Assert.assertThat((Object)auth.getNextHeader(), (Matcher)Matchers.is((Object)17));
        Assert.assertThat((Object)auth.getPayloadLength(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)auth.getSecurityParamIndex(), (Matcher)Matchers.is((Object)324478056));
        Assert.assertThat((Object)auth.getSequence(), (Matcher)Matchers.is((Object)0xFFFF00));
        Assert.assertArrayEquals((byte[])auth.getIntegrityCheck(), (byte[])icv);
    }

    @Test
    public void testEqual() {
        Authentication auth1 = new Authentication();
        auth1.setNextHeader((byte)17);
        auth1.setPayloadLength((byte)2);
        auth1.setSecurityParamIndex(324478056);
        auth1.setSequence(0xFFFF00);
        auth1.setIngegrityCheck(icv);
        Authentication auth2 = new Authentication();
        auth2.setNextHeader((byte)17);
        auth2.setPayloadLength((byte)2);
        auth2.setSecurityParamIndex(324478055);
        auth2.setSequence(0xFFFF00);
        auth2.setIngegrityCheck(icv);
        Assert.assertTrue((boolean)auth1.equals((Object)auth1));
        Assert.assertFalse((boolean)auth1.equals((Object)auth2));
    }

    static {
        icv = new byte[]{17, 34, 51, 68};
    }
}

