/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ipv6;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.UDP;
import org.onlab.packet.ipv6.Fragment;

public class FragmentTest {
    private static Data data;
    private static UDP udp;
    private static byte[] bytePacket;
    private Deserializer<Fragment> deserializer;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        data = new Data();
        data.setData("testSerialize".getBytes());
        udp = new UDP();
        udp.setPayload((IPacket)data);
        byte[] bytePayload = udp.serialize();
        byte[] byteHeader = new byte[]{17, 0, 0, -7, 0, 0, 19, 87};
        bytePacket = new byte[byteHeader.length + bytePayload.length];
        System.arraycopy(byteHeader, 0, bytePacket, 0, byteHeader.length);
        System.arraycopy(bytePayload, 0, bytePacket, byteHeader.length, bytePayload.length);
    }

    @Before
    public void setUp() {
        this.deserializer = Fragment.deserializer();
    }

    @Test
    public void testSerialize() {
        Fragment frag = new Fragment();
        frag.setNextHeader((byte)17);
        frag.setFragmentOffset((short)31);
        frag.setMoreFragment((byte)1);
        frag.setIdentification(4951);
        frag.setPayload((IPacket)udp);
        Assert.assertArrayEquals((byte[])frag.serialize(), (byte[])bytePacket);
    }

    @Test
    public void testDeserialize() throws DeserializationException {
        Fragment frag = (Fragment)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        Assert.assertThat((Object)frag.getNextHeader(), (Matcher)Matchers.is((Object)17));
        Assert.assertThat((Object)frag.getFragmentOffset(), (Matcher)Matchers.is((Object)31));
        Assert.assertThat((Object)frag.getMoreFragment(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)frag.getIdentification(), (Matcher)Matchers.is((Object)4951));
    }

    @Test
    public void testEqual() {
        Fragment frag1 = new Fragment();
        frag1.setNextHeader((byte)17);
        frag1.setFragmentOffset((short)31);
        frag1.setMoreFragment((byte)1);
        frag1.setIdentification(4951);
        Fragment frag2 = new Fragment();
        frag2.setNextHeader((byte)17);
        frag2.setFragmentOffset((short)31);
        frag2.setMoreFragment((byte)1);
        frag2.setIdentification(4952);
        Assert.assertTrue((boolean)frag1.equals((Object)frag1));
        Assert.assertFalse((boolean)frag1.equals((Object)frag2));
    }
}

