/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ndp;

import java.nio.ByteBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.ndp.NeighborDiscoveryOptions;
import org.onlab.packet.ndp.RouterAdvertisement;

public class RouterAdvertisementTest {
    private static final MacAddress MAC_ADDRESS = MacAddress.valueOf((String)"11:22:33:44:55:66");
    private static byte[] bytePacket;
    private Deserializer<RouterAdvertisement> deserializer = RouterAdvertisement.deserializer();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        byte[] byteHeader = new byte[]{3, -64, 2, 88, 0, 0, 3, -24, 0, 0, 1, -12, 2, 1, 17, 34, 51, 68, 85, 102};
        bytePacket = new byte[byteHeader.length];
        System.arraycopy(byteHeader, 0, bytePacket, 0, byteHeader.length);
    }

    @Test
    public void testSerialize() {
        RouterAdvertisement ra = new RouterAdvertisement();
        ra.setCurrentHopLimit((byte)3);
        ra.setMFlag((byte)1);
        ra.setOFlag((byte)1);
        ra.setRouterLifetime((short)600);
        ra.setReachableTime(1000);
        ra.setRetransmitTimer(500);
        ra.addOption((byte)2, MAC_ADDRESS.toBytes());
        Assert.assertArrayEquals((byte[])ra.serialize(), (byte[])bytePacket);
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(RouterAdvertisement.deserializer());
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        byte[] raHeader = new byte[12];
        ByteBuffer.wrap(bytePacket).get(raHeader);
        PacketTestUtils.testDeserializeTruncated(RouterAdvertisement.deserializer(), raHeader);
    }

    @Test
    public void testDeserialize() throws DeserializationException {
        RouterAdvertisement ra = (RouterAdvertisement)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        Assert.assertThat((Object)ra.getCurrentHopLimit(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)ra.getMFlag(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)ra.getOFlag(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)ra.getRouterLifetime(), (Matcher)Matchers.is((Object)600));
        Assert.assertThat((Object)ra.getReachableTime(), (Matcher)Matchers.is((Object)1000));
        Assert.assertThat((Object)ra.getRetransmitTimer(), (Matcher)Matchers.is((Object)500));
        Assert.assertThat((Object)ra.getOptions().size(), (Matcher)Matchers.is((Object)1));
        NeighborDiscoveryOptions.Option option = (NeighborDiscoveryOptions.Option)ra.getOptions().get(0);
        Assert.assertThat((Object)option.type(), (Matcher)Matchers.is((Object)2));
        Assert.assertArrayEquals((byte[])option.data(), (byte[])MAC_ADDRESS.toBytes());
    }

    @Test
    public void testEqual() {
        RouterAdvertisement ra1 = new RouterAdvertisement();
        ra1.setCurrentHopLimit((byte)3);
        ra1.setMFlag((byte)1);
        ra1.setOFlag((byte)1);
        ra1.setRouterLifetime((short)600);
        ra1.setReachableTime(1000);
        ra1.setRetransmitTimer(500);
        ra1.addOption((byte)2, MAC_ADDRESS.toBytes());
        RouterAdvertisement ra2 = new RouterAdvertisement();
        ra2.setCurrentHopLimit((byte)3);
        ra2.setMFlag((byte)0);
        ra2.setOFlag((byte)0);
        ra2.setRouterLifetime((short)500);
        ra2.setReachableTime(1000);
        ra2.setRetransmitTimer(500);
        ra2.addOption((byte)2, MAC_ADDRESS.toBytes());
        Assert.assertTrue((boolean)ra1.equals((Object)ra1));
        Assert.assertFalse((boolean)ra1.equals((Object)ra2));
    }
}

