/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import java.util.List;
import java.util.Timer;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.junit.TestTools;
import org.onlab.util.AbstractAccumulator;

public class AbstractAccumulatorTest {
    private final Timer timer = new Timer();

    @Test
    public void basics() throws Exception {
        TestAccumulator accumulator = new TestAccumulator();
        Assert.assertEquals((String)"incorrect timer", (Object)this.timer, (Object)accumulator.timer());
        Assert.assertEquals((String)"incorrect max events", (long)5L, (long)accumulator.maxItems());
        Assert.assertEquals((String)"incorrect max ms", (long)100L, (long)accumulator.maxBatchMillis());
        Assert.assertEquals((String)"incorrect idle ms", (long)70L, (long)accumulator.maxIdleMillis());
    }

    @Ignore(value="FIXME: timing sensitive test failing randomly.")
    @Test
    public void eventTrigger() {
        TestAccumulator accumulator = new TestAccumulator();
        accumulator.add(new TestItem("a"));
        accumulator.add(new TestItem("b"));
        accumulator.add(new TestItem("c"));
        accumulator.add(new TestItem("d"));
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.add(new TestItem("e"));
        TestTools.delay((int)20);
        Assert.assertFalse((String)"should have fired", (boolean)accumulator.batch.isEmpty());
        Assert.assertEquals((String)"incorrect batch", (Object)"abcde", (Object)accumulator.batch);
    }

    @Ignore(value="FIXME: timing sensitive test failing randomly.")
    @Test
    public void timeTrigger() {
        TestAccumulator accumulator = new TestAccumulator();
        accumulator.add(new TestItem("a"));
        TestTools.delay((int)30);
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.add(new TestItem("b"));
        TestTools.delay((int)30);
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.add(new TestItem("c"));
        TestTools.delay((int)30);
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.add(new TestItem("d"));
        TestTools.delay((int)60);
        Assert.assertFalse((String)"should have fired", (boolean)accumulator.batch.isEmpty());
        Assert.assertEquals((String)"incorrect batch", (Object)"abcd", (Object)accumulator.batch);
    }

    @Ignore(value="FIXME: timing sensitive test failing randomly.")
    @Test
    public void idleTrigger() {
        TestAccumulator accumulator = new TestAccumulator();
        accumulator.add(new TestItem("a"));
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.add(new TestItem("b"));
        TestTools.delay((int)80);
        Assert.assertFalse((String)"should have fired", (boolean)accumulator.batch.isEmpty());
        Assert.assertEquals((String)"incorrect batch", (Object)"ab", (Object)accumulator.batch);
    }

    @Ignore(value="FIXME: timing sensitive test failing randomly.")
    @Test
    public void readyIdleTrigger() {
        TestAccumulator accumulator = new TestAccumulator();
        accumulator.ready = false;
        accumulator.add(new TestItem("a"));
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.add(new TestItem("b"));
        TestTools.delay((int)80);
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.ready = true;
        TestTools.delay((int)80);
        Assert.assertFalse((String)"should have fired", (boolean)accumulator.batch.isEmpty());
        Assert.assertEquals((String)"incorrect batch", (Object)"ab", (Object)accumulator.batch);
    }

    @Ignore(value="FIXME: timing sensitive test failing randomly.")
    @Test
    public void readyLongTrigger() {
        TestAccumulator accumulator = new TestAccumulator();
        accumulator.ready = false;
        TestTools.delay((int)120);
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.add(new TestItem("a"));
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.ready = true;
        TestTools.delay((int)80);
        Assert.assertFalse((String)"should have fired", (boolean)accumulator.batch.isEmpty());
        Assert.assertEquals((String)"incorrect batch", (Object)"a", (Object)accumulator.batch);
    }

    @Ignore(value="FIXME: timing sensitive test failing randomly.")
    @Test
    public void readyMaxTrigger() {
        TestAccumulator accumulator = new TestAccumulator();
        accumulator.ready = false;
        accumulator.add(new TestItem("a"));
        accumulator.add(new TestItem("b"));
        accumulator.add(new TestItem("c"));
        accumulator.add(new TestItem("d"));
        accumulator.add(new TestItem("e"));
        accumulator.add(new TestItem("f"));
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.ready = true;
        accumulator.add(new TestItem("g"));
        TestTools.delay((int)5);
        Assert.assertFalse((String)"should have fired", (boolean)accumulator.batch.isEmpty());
        Assert.assertEquals((String)"incorrect batch", (Object)"abcdefg", (Object)accumulator.batch);
    }

    @Ignore(value="FIXME: timing sensitive test failing randomly.")
    @Test
    public void stormTest() {
        TestAccumulator accumulator = new TestAccumulator();
        IntStream.range(0, 1000).forEach(i -> accumulator.add(new TestItem("#" + i)));
        TestTools.assertAfter((int)100, () -> Assert.assertEquals((String)"wrong item count", (long)1000L, (long)testAccumulator.itemCount));
        Assert.assertEquals((String)"wrong batch count", (long)200L, (long)accumulator.batchCount);
    }

    private class TestAccumulator
    extends AbstractAccumulator<TestItem> {
        String batch;
        boolean ready;
        int batchCount;
        int itemCount;

        protected TestAccumulator() {
            super(AbstractAccumulatorTest.this.timer, 5, 100, 70);
            this.batch = "";
            this.ready = true;
            this.batchCount = 0;
            this.itemCount = 0;
        }

        public void processItems(List<TestItem> items) {
            ++this.batchCount;
            this.itemCount += items.size();
            for (TestItem item : items) {
                this.batch = this.batch + item.s;
            }
        }

        public boolean isReady() {
            return this.ready;
        }
    }

    private class TestItem {
        private final String s;

        public TestItem(String s) {
            this.s = s;
        }
    }
}

