/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import org.onlab.graph.Edge;
import org.onlab.graph.Path;
import org.onlab.graph.Vertex;

public class DisjointPathPair<V extends Vertex, E extends Edge<V>>
implements Path<V, E> {
    public Path<V, E> path1;
    public Path<V, E> path2;
    boolean usingPath1 = true;

    public DisjointPathPair(Path<V, E> p1, Path<V, E> p2) {
        this.path1 = p1;
        this.path2 = p2;
    }

    @Override
    public V src() {
        return this.path1.src();
    }

    @Override
    public V dst() {
        return this.path1.dst();
    }

    @Override
    public double cost() {
        if (!this.hasBackup()) {
            return this.path1.cost();
        }
        return this.path1.cost() + this.path2.cost();
    }

    @Override
    public List<E> edges() {
        if (this.usingPath1 || !this.hasBackup()) {
            return this.path1.edges();
        }
        return this.path2.edges();
    }

    public boolean hasBackup() {
        return this.path2 != null && this.path2.edges() != null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("src", this.src()).add("dst", this.dst()).add("cost", this.cost()).add("edges", this.edges()).toString();
    }

    public int hashCode() {
        ImmutableSet paths = !this.hasBackup() ? ImmutableSet.of(this.path1) : ImmutableSet.of(this.path1, this.path2);
        return Objects.hash(paths);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DisjointPathPair) {
            DisjointPathPair other = (DisjointPathPair)obj;
            return Objects.equals(this.src(), other.src()) && Objects.equals(this.dst(), other.dst()) && Objects.equals(this.path1, other.path1) && Objects.equals(this.path2, other.path2) || Objects.equals(this.path1, other.path2) && Objects.equals(this.path2, other.path1);
        }
        return false;
    }

    public int size() {
        if (this.hasBackup()) {
            return 2;
        }
        return 1;
    }
}

