/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.ICMP;
import org.onlab.packet.IGMP;
import org.onlab.packet.IPacket;
import org.onlab.packet.PIM;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.TCP;
import org.onlab.packet.UDP;

public class IPv4
extends BasePacket {
    public static final byte PROTOCOL_ICMP = 1;
    public static final byte PROTOCOL_IGMP = 2;
    public static final byte PROTOCOL_TCP = 6;
    public static final byte PROTOCOL_UDP = 17;
    public static final byte PROTOCOL_PIM = 103;
    public static final Map<Byte, Deserializer<? extends IPacket>> PROTOCOL_DESERIALIZER_MAP = new HashMap<Byte, Deserializer<? extends IPacket>>();
    private static final byte DSCP_MASK = 63;
    private static final byte DSCP_OFFSET = 2;
    private static final byte ECN_MASK = 3;
    private static final short HEADER_LENGTH = 20;
    protected byte version = (byte)4;
    protected byte headerLength;
    protected byte diffServ;
    protected short totalLength;
    protected short identification;
    protected byte flags;
    protected short fragmentOffset;
    protected byte ttl;
    protected byte protocol;
    protected short checksum;
    protected int sourceAddress;
    protected int destinationAddress;
    protected byte[] options;
    protected boolean isTruncated = false;

    public byte getVersion() {
        return this.version;
    }

    public IPv4 setVersion(byte version) {
        this.version = version;
        return this;
    }

    public byte getHeaderLength() {
        return this.headerLength;
    }

    public byte getDscp() {
        return (byte)(this.diffServ >>> 2 & 0x3F);
    }

    public IPv4 setDscp(byte dscp) {
        this.diffServ = (byte)(this.diffServ & 0xFFFFFF03);
        this.diffServ = (byte)(this.diffServ | (dscp & 0x3F) << 2);
        return this;
    }

    public byte getEcn() {
        return (byte)(this.diffServ & 3);
    }

    public IPv4 setEcn(byte ecn) {
        this.diffServ = (byte)(this.diffServ & 0xFFFFFFFC);
        this.diffServ = (byte)(this.diffServ | ecn & 3);
        return this;
    }

    public byte getDiffServ() {
        return this.diffServ;
    }

    public IPv4 setDiffServ(byte diffServ) {
        this.diffServ = diffServ;
        return this;
    }

    public short getTotalLength() {
        return this.totalLength;
    }

    public short getIdentification() {
        return this.identification;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public void setTruncated(boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public IPv4 setIdentification(short identification) {
        this.identification = identification;
        return this;
    }

    public byte getFlags() {
        return this.flags;
    }

    public IPv4 setFlags(byte flags) {
        this.flags = flags;
        return this;
    }

    public short getFragmentOffset() {
        return this.fragmentOffset;
    }

    public IPv4 setFragmentOffset(short fragmentOffset) {
        this.fragmentOffset = fragmentOffset;
        return this;
    }

    public byte getTtl() {
        return this.ttl;
    }

    public IPv4 setTtl(byte ttl) {
        this.ttl = ttl;
        return this;
    }

    public byte getProtocol() {
        return this.protocol;
    }

    public IPv4 setProtocol(byte protocol) {
        this.protocol = protocol;
        return this;
    }

    public short getChecksum() {
        return this.checksum;
    }

    public IPv4 setChecksum(short checksum) {
        this.checksum = checksum;
        return this;
    }

    @Override
    public void resetChecksum() {
        this.checksum = 0;
        super.resetChecksum();
    }

    public int getSourceAddress() {
        return this.sourceAddress;
    }

    public IPv4 setSourceAddress(int sourceAddress) {
        this.sourceAddress = sourceAddress;
        return this;
    }

    public IPv4 setSourceAddress(String sourceAddress) {
        this.sourceAddress = IPv4.toIPv4Address(sourceAddress);
        return this;
    }

    public int getDestinationAddress() {
        return this.destinationAddress;
    }

    public IPv4 setDestinationAddress(int destinationAddress) {
        this.destinationAddress = destinationAddress;
        return this;
    }

    public IPv4 setDestinationAddress(String destinationAddress) {
        this.destinationAddress = IPv4.toIPv4Address(destinationAddress);
        return this;
    }

    public byte[] getOptions() {
        return this.options;
    }

    public IPv4 setOptions(byte[] options) {
        if (options != null && options.length % 4 > 0) {
            throw new IllegalArgumentException("Options length must be a multiple of 4");
        }
        this.options = options;
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        int optionsLength = 0;
        if (this.options != null) {
            optionsLength = this.options.length / 4;
        }
        this.headerLength = (byte)(5 + optionsLength);
        this.totalLength = (short)(this.headerLength * 4 + (payloadData == null ? 0 : payloadData.length));
        byte[] data = new byte[this.totalLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put((byte)((this.version & 0xF) << 4 | this.headerLength & 0xF));
        bb.put(this.diffServ);
        bb.putShort(this.totalLength);
        bb.putShort(this.identification);
        bb.putShort((short)((this.flags & 7) << 13 | this.fragmentOffset & 0x1FFF));
        bb.put(this.ttl);
        bb.put(this.protocol);
        bb.putShort(this.checksum);
        bb.putInt(this.sourceAddress);
        bb.putInt(this.destinationAddress);
        if (this.options != null) {
            bb.put(this.options);
        }
        if (payloadData != null) {
            bb.put(payloadData);
        }
        if (this.checksum == 0) {
            bb.rewind();
            int accumulation = 0;
            for (int i = 0; i < this.headerLength * 2; ++i) {
                accumulation += 0xFFFF & bb.getShort();
            }
            accumulation = (accumulation >> 16 & 0xFFFF) + (accumulation & 0xFFFF);
            this.checksum = (short)(~accumulation & 0xFFFF);
            bb.putShort(10, this.checksum);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        this.version = bb.get();
        this.headerLength = (byte)(this.version & 0xF);
        this.version = (byte)(this.version >> 4 & 0xF);
        this.diffServ = bb.get();
        this.totalLength = bb.getShort();
        this.identification = bb.getShort();
        short sscratch = bb.getShort();
        this.flags = (byte)(sscratch >> 13 & 7);
        this.fragmentOffset = (short)(sscratch & 0x1FFF);
        this.ttl = bb.get();
        this.protocol = bb.get();
        this.checksum = bb.getShort();
        this.sourceAddress = bb.getInt();
        this.destinationAddress = bb.getInt();
        if (this.headerLength > 5) {
            int optionsLength = (this.headerLength - 5) * 4;
            this.options = new byte[optionsLength];
            bb.get(this.options);
        }
        this.isTruncated = this.totalLength != length;
        Deserializer<IPacket> deserializer = PROTOCOL_DESERIALIZER_MAP.containsKey(this.protocol) ? PROTOCOL_DESERIALIZER_MAP.get(this.protocol) : Data.deserializer();
        try {
            this.payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            this.payload.setParent(this);
        }
        catch (DeserializationException e) {
            return this;
        }
        return this;
    }

    public static int toIPv4Address(String ipAddress) {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Specified IPv4 address mustcontain 4 sets of numerical digits separated by periods");
        }
        String[] octets = ipAddress.split("\\.");
        if (octets.length != 4) {
            throw new IllegalArgumentException("Specified IPv4 address mustcontain 4 sets of numerical digits separated by periods");
        }
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result |= Integer.parseInt(octets[i]) << (3 - i) * 8;
        }
        return result;
    }

    public static int toIPv4Address(byte[] ipAddress) {
        int ip = 0;
        for (int i = 0; i < 4; ++i) {
            int t = (ipAddress[i] & 0xFF) << (3 - i) * 8;
            ip |= t;
        }
        return ip;
    }

    public static String fromIPv4Address(int ipAddress) {
        StringBuffer sb = new StringBuffer();
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = ipAddress >> (3 - i) * 8 & 0xFF;
            sb.append(result);
            if (i == 3) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public static String fromIPv4AddressCollection(Collection<Integer> ipAddresses) {
        if (ipAddresses == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (Integer ip : ipAddresses) {
            sb.append(IPv4.fromIPv4Address(ip));
            sb.append(",");
        }
        sb.replace(sb.length() - 1, sb.length(), "]");
        return sb.toString();
    }

    public static byte[] toIPv4AddressBytes(String ipAddress) {
        String[] octets = ipAddress.split("\\.");
        if (octets.length != 4) {
            throw new IllegalArgumentException("Specified IPv4 address mustcontain 4 sets of numerical digits separated by periods");
        }
        byte[] result = new byte[4];
        for (int i = 0; i < 4; ++i) {
            result[i] = Integer.valueOf(octets[i]).byteValue();
        }
        return result;
    }

    public static byte[] toIPv4AddressBytes(int ipAddress) {
        return new byte[]{(byte)(ipAddress >>> 24), (byte)(ipAddress >>> 16), (byte)(ipAddress >>> 8), (byte)ipAddress};
    }

    @Override
    public int hashCode() {
        int prime = 2521;
        int result = super.hashCode();
        result = 2521 * result + this.checksum;
        result = 2521 * result + this.destinationAddress;
        result = 2521 * result + this.diffServ;
        result = 2521 * result + this.flags;
        result = 2521 * result + this.fragmentOffset;
        result = 2521 * result + this.headerLength;
        result = 2521 * result + this.identification;
        result = 2521 * result + Arrays.hashCode(this.options);
        result = 2521 * result + this.protocol;
        result = 2521 * result + this.sourceAddress;
        result = 2521 * result + this.totalLength;
        result = 2521 * result + this.ttl;
        result = 2521 * result + this.version;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof IPv4)) {
            return false;
        }
        IPv4 other = (IPv4)obj;
        if (this.checksum != other.checksum) {
            return false;
        }
        if (this.destinationAddress != other.destinationAddress) {
            return false;
        }
        if (this.diffServ != other.diffServ) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (this.fragmentOffset != other.fragmentOffset) {
            return false;
        }
        if (this.headerLength != other.headerLength) {
            return false;
        }
        if (this.identification != other.identification) {
            return false;
        }
        if (!Arrays.equals(this.options, other.options)) {
            return false;
        }
        if (this.protocol != other.protocol) {
            return false;
        }
        if (this.sourceAddress != other.sourceAddress) {
            return false;
        }
        if (this.totalLength != other.totalLength) {
            return false;
        }
        if (this.ttl != other.ttl) {
            return false;
        }
        return this.version == other.version;
    }

    public static Deserializer<IPv4> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 20);
            IPv4 ipv4 = new IPv4();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            byte versionByte = bb.get();
            ipv4.headerLength = (byte)(versionByte & 0xF);
            ipv4.setVersion((byte)(versionByte >> 4 & 0xF));
            ipv4.setDiffServ(bb.get());
            ipv4.totalLength = bb.getShort();
            ipv4.identification = bb.getShort();
            short flagsFragment = bb.getShort();
            ipv4.flags = (byte)(flagsFragment >> 13 & 7);
            ipv4.fragmentOffset = (short)(flagsFragment & 0x1FFF);
            ipv4.ttl = bb.get();
            ipv4.protocol = bb.get();
            ipv4.checksum = bb.getShort();
            ipv4.sourceAddress = bb.getInt();
            ipv4.destinationAddress = bb.getInt();
            if (ipv4.headerLength > 5) {
                PacketUtils.checkHeaderLength(length, ipv4.headerLength * 4);
                int optionsLength = (ipv4.headerLength - 5) * 4;
                ipv4.options = new byte[optionsLength];
                bb.get(ipv4.options);
            }
            Deserializer<IPacket> deserializer = PROTOCOL_DESERIALIZER_MAP.containsKey(ipv4.protocol) ? PROTOCOL_DESERIALIZER_MAP.get(ipv4.protocol) : Data.deserializer();
            ipv4.payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            ipv4.payload.setParent(ipv4);
            ipv4.isTruncated = ipv4.totalLength != length;
            return ipv4;
        };
    }

    static {
        PROTOCOL_DESERIALIZER_MAP.put((byte)1, ICMP.deserializer());
        PROTOCOL_DESERIALIZER_MAP.put((byte)2, IGMP.deserializer());
        PROTOCOL_DESERIALIZER_MAP.put((byte)6, TCP.deserializer());
        PROTOCOL_DESERIALIZER_MAP.put((byte)17, UDP.deserializer());
        PROTOCOL_DESERIALIZER_MAP.put((byte)103, PIM.deserializer());
    }
}

