/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DHCP;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.PacketUtils;

public class UDP
extends BasePacket {
    public static final Map<Integer, Deserializer<? extends IPacket>> PORT_DESERIALIZER_MAP = new HashMap<Integer, Deserializer<? extends IPacket>>();
    public static final int DHCP_SERVER_PORT = 67;
    public static final int DHCP_CLIENT_PORT = 68;
    private static final short UDP_HEADER_LENGTH = 8;
    protected int sourcePort;
    protected int destinationPort;
    protected short length;
    protected short checksum;

    public int getSourcePort() {
        return this.sourcePort;
    }

    public UDP setSourcePort(int sourcePort) {
        this.sourcePort = sourcePort;
        return this;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public UDP setDestinationPort(int destinationPort) {
        this.destinationPort = destinationPort;
        return this;
    }

    public short getLength() {
        return this.length;
    }

    public short getChecksum() {
        return this.checksum;
    }

    public UDP setChecksum(short checksum) {
        this.checksum = checksum;
        return this;
    }

    @Override
    public void resetChecksum() {
        this.checksum = 0;
        super.resetChecksum();
    }

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        this.length = (short)(8 + (payloadData == null ? 0 : payloadData.length));
        byte[] data = new byte[this.length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putShort((short)(this.sourcePort & 0xFFFF));
        bb.putShort((short)(this.destinationPort & 0xFFFF));
        bb.putShort(this.length);
        bb.putShort(this.checksum);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        if (this.parent != null && this.parent instanceof IPv4) {
            ((IPv4)this.parent).setProtocol((byte)17);
        }
        if (this.checksum == 0) {
            bb.rewind();
            int accumulation = 0;
            if (this.parent != null) {
                if (this.parent instanceof IPv4) {
                    IPv4 ipv4 = (IPv4)this.parent;
                    accumulation += (ipv4.getSourceAddress() >> 16 & 0xFFFF) + (ipv4.getSourceAddress() & 0xFFFF);
                    accumulation += (ipv4.getDestinationAddress() >> 16 & 0xFFFF) + (ipv4.getDestinationAddress() & 0xFFFF);
                    accumulation += ipv4.getProtocol() & 0xFF;
                    accumulation += this.length & 0xFFFF;
                } else if (this.parent instanceof IPv6) {
                    IPv6 ipv6 = (IPv6)this.parent;
                    int bbLength = 38;
                    ByteBuffer bbChecksum = ByteBuffer.allocate(38);
                    bbChecksum.put(ipv6.getSourceAddress());
                    bbChecksum.put(ipv6.getDestinationAddress());
                    bbChecksum.put((byte)0);
                    bbChecksum.put(ipv6.getNextHeader());
                    bbChecksum.putInt(this.length);
                    bbChecksum.rewind();
                    for (int i = 0; i < 19; ++i) {
                        accumulation += 0xFFFF & bbChecksum.getShort();
                    }
                }
            }
            for (int i = 0; i < this.length / 2; ++i) {
                accumulation += 0xFFFF & bb.getShort();
            }
            if (this.length % 2 > 0) {
                accumulation += (bb.get() & 0xFF) << 8;
            }
            accumulation = (accumulation >> 16 & 0xFFFF) + (accumulation & 0xFFFF);
            this.checksum = (short)(~accumulation & 0xFFFF);
            bb.putShort(6, this.checksum);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        this.sourcePort = bb.getShort() & 0xFFFF;
        this.destinationPort = bb.getShort() & 0xFFFF;
        this.length = bb.getShort();
        this.checksum = bb.getShort();
        Deserializer<? extends IPacket> deserializer = PORT_DESERIALIZER_MAP.containsKey(this.destinationPort) ? PORT_DESERIALIZER_MAP.get(this.destinationPort) : (PORT_DESERIALIZER_MAP.containsKey(this.sourcePort) ? PORT_DESERIALIZER_MAP.get(this.sourcePort) : Data.deserializer());
        try {
            this.payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            this.payload.setParent(this);
        }
        catch (DeserializationException e) {
            return this;
        }
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.checksum;
        result = 5807 * result + this.destinationPort;
        result = 5807 * result + this.length;
        result = 5807 * result + this.sourcePort;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof UDP)) {
            return false;
        }
        UDP other = (UDP)obj;
        if (this.checksum != other.checksum) {
            return false;
        }
        if (this.destinationPort != other.destinationPort) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        return this.sourcePort == other.sourcePort;
    }

    public static Deserializer<UDP> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 8);
            UDP udp = new UDP();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            udp.sourcePort = bb.getShort() & 0xFFFF;
            udp.destinationPort = bb.getShort() & 0xFFFF;
            udp.length = bb.getShort();
            udp.checksum = bb.getShort();
            Deserializer<? extends IPacket> deserializer = PORT_DESERIALIZER_MAP.containsKey(udp.destinationPort) ? PORT_DESERIALIZER_MAP.get(udp.destinationPort) : (PORT_DESERIALIZER_MAP.containsKey(udp.sourcePort) ? PORT_DESERIALIZER_MAP.get(udp.sourcePort) : Data.deserializer());
            udp.payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            udp.payload.setParent(udp);
            return udp;
        };
    }

    static {
        PORT_DESERIALIZER_MAP.put(67, DHCP.deserializer());
        PORT_DESERIALIZER_MAP.put(68, DHCP.deserializer());
    }
}

