/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ipv6;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv6;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.ipv6.IExtensionHeader;

public class Routing
extends BasePacket
implements IExtensionHeader {
    public static final byte FIXED_HEADER_LENGTH = 4;
    public static final byte FIXED_ROUTING_DATA_LENGTH = 4;
    public static final byte LENGTH_UNIT = 8;
    protected byte nextHeader;
    protected byte headerExtLength;
    protected byte routingType;
    protected byte segmentsLeft;
    protected byte[] routingData;

    @Override
    public byte getNextHeader() {
        return this.nextHeader;
    }

    @Override
    public Routing setNextHeader(byte nextHeader) {
        this.nextHeader = nextHeader;
        return this;
    }

    public byte getHeaderExtLength() {
        return this.headerExtLength;
    }

    public Routing setHeaderExtLength(byte headerExtLength) {
        this.headerExtLength = headerExtLength;
        return this;
    }

    public byte getRoutingType() {
        return this.routingType;
    }

    public Routing setRoutingType(byte routingType) {
        this.routingType = routingType;
        return this;
    }

    public byte getSegmentsLeft() {
        return this.segmentsLeft;
    }

    public Routing setSegmntsLeft(byte segmentsLeft) {
        this.segmentsLeft = segmentsLeft;
        return this;
    }

    public byte[] getRoutingData() {
        return this.routingData;
    }

    public Routing setRoutingData(byte[] routingData) {
        this.routingData = Arrays.copyOfRange(routingData, 0, routingData.length);
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        int headerLength = 4 + this.routingData.length;
        int payloadLength = 0;
        if (payloadData != null) {
            payloadLength = payloadData.length;
        }
        byte[] data = new byte[headerLength + payloadLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.nextHeader);
        bb.put(this.headerExtLength);
        bb.put(this.routingType);
        bb.put(this.segmentsLeft);
        bb.put(this.routingData, 0, this.routingData.length);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        if (this.parent != null && this.parent instanceof IExtensionHeader) {
            ((IExtensionHeader)((Object)this.parent)).setNextHeader((byte)43);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        Deserializer<IPacket> deserializer;
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        this.nextHeader = bb.get();
        this.headerExtLength = bb.get();
        this.routingType = bb.get();
        this.segmentsLeft = bb.get();
        int dataLength = 4 + 8 * this.headerExtLength;
        this.routingData = new byte[dataLength];
        bb.get(this.routingData, 0, dataLength);
        if (IPv6.PROTOCOL_DESERIALIZER_MAP.containsKey(this.nextHeader)) {
            deserializer = IPv6.PROTOCOL_DESERIALIZER_MAP.get(this.nextHeader);
        } else {
            new Data();
            deserializer = Data.deserializer();
        }
        try {
            this.payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            this.payload.setParent(this);
        }
        catch (DeserializationException e) {
            return this;
        }
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.nextHeader;
        result = 5807 * result + this.headerExtLength;
        result = 5807 * result + this.routingType;
        result = 5807 * result + this.segmentsLeft;
        for (byte b : this.routingData) {
            result = 5807 * result + b;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Routing)) {
            return false;
        }
        Routing other = (Routing)obj;
        if (this.nextHeader != other.nextHeader) {
            return false;
        }
        if (this.headerExtLength != other.headerExtLength) {
            return false;
        }
        if (this.routingType != other.routingType) {
            return false;
        }
        if (this.segmentsLeft != other.segmentsLeft) {
            return false;
        }
        return Arrays.equals(this.routingData, other.routingData);
    }

    public static Deserializer<Routing> deserializer() {
        return (data, offset, length) -> {
            Deserializer<IPacket> deserializer;
            PacketUtils.checkInput(data, offset, length, 4);
            Routing routing = new Routing();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            routing.nextHeader = bb.get();
            routing.headerExtLength = bb.get();
            routing.routingType = bb.get();
            routing.segmentsLeft = bb.get();
            int dataLength = 4 + 8 * routing.headerExtLength;
            PacketUtils.checkHeaderLength(bb.remaining(), dataLength);
            routing.routingData = new byte[dataLength];
            bb.get(routing.routingData, 0, dataLength);
            if (IPv6.PROTOCOL_DESERIALIZER_MAP.containsKey(routing.nextHeader)) {
                deserializer = IPv6.PROTOCOL_DESERIALIZER_MAP.get(routing.nextHeader);
            } else {
                new Data();
                deserializer = Data.deserializer();
            }
            routing.payload = deserializer.deserialize(data, bb.position(), bb.limit() - bb.position());
            routing.payload.setParent(routing);
            return routing;
        };
    }
}

